package com.gingersoft.gsa.cloud.account.user.info;

import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.account.user.UserConstans;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:
 */
public class UserInfoManger {

    private static UserInfoManger userInfoManger = null;

    private UserInfoManger() {
    }

    public static UserInfoManger getInstance() {
        if (userInfoManger == null) {
            synchronized (UserInfoManger.class) {
                if (userInfoManger == null) {
                    userInfoManger = new UserInfoManger();
                }
            }
        }
        return userInfoManger;
    }

    public void setUserInfoToLocation(UserInfo info) {
        SPUtils.put(UserConstans.token, info.getUserName());
        SPUtils.put(UserConstans.memberId, info.getUserName());
        SPUtils.put(UserConstans.memberName, info.getUserName());
    }

    public static String getLoginToken() {
        return (String) SPUtils.get(UserConstans.token, "");
    }

    public static int getMemberId() {
        return (int) SPUtils.get(UserConstans.memberId, 0);
    }

    public static String getMemberName() {
        return (String) SPUtils.get(UserConstans.memberName, "");
    }

}
