package com.gingersoft.gsa.cloud.table.mvp.ui.activity.orderManager;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;
import com.gingersoft.gsa.cloud.base.order.bean.response.OrderDiscountResponse;
import com.gingersoft.gsa.cloud.base.order.bean.response.OrderResponse;
import com.gingersoft.gsa.cloud.base.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.base.order.billItem.BillOrderMoney;
import com.gingersoft.gsa.cloud.base.order.cart.ShoppingCart;
import com.gingersoft.gsa.cloud.base.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.base.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerOrderDetailComponent;
import com.gingersoft.gsa.cloud.table.mvp.contract.OrderDetailContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.OrderAssemblyUtil;
import com.gingersoft.gsa.cloud.table.mvp.presenter.orderManager.OrderDetailPresenter;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.MealStandActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.OrderCenterDetailFoodAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.OrderCenterMoneyAdapter;
import com.gingersoft.gsa.cloud.constans.PrintConstans;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem3;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description: 訂單詳情頁#顯示單條該餐廳下已結賬單
 * <p>
 * Created by MVPArmsTemplate on 03/13/2020 14:29
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class OrderDetailActivity extends BaseActivity<OrderDetailPresenter> implements OrderDetailContract.View {

    @BindView(R2.id.topbar)
    QMUITopBar mTopBar;

    @BindView(R2.id.scrollview)
    ScrollView scrollview;
    @BindView(R2.id.tv_table_name)
    TextView tv_table_name;
    @BindView(R2.id.tv_people_num)
    TextView tv_people_num;
    @BindView(R2.id.tv_order_num)
    TextView tv_order_num;
    @BindView(R2.id.tv_open_time)
    TextView tv_open_time;
    @BindView(R2.id.tv_pay_time)
    TextView tv_pay_time;

    @BindView(R2.id.tv_food_detail_text)
    TextView tv_food_detail_text;
    @BindView(R2.id.recycler_food)
    RecyclerView recycler_food;
    @BindView(R2.id.recycler_order_moeny)
    RecyclerView recycler_order_moeny;
    @BindView(R2.id.recycler_pay_method)
    RecyclerView recycler_pay_method;

    @BindView(R2.id.tv_total_text)
    TextView tv_total_text;
    @BindView(R2.id.tv_total_money_text)
    TextView tv_total_money_text;

    @BindView(R2.id.tv_total)
    TextView tv_total;
    @BindView(R2.id.tv_total_money)
    TextView tv_total_money;

    @BindView(R2.id.btn_print_order)
    QMUIAlphaButton btn_print_order;
    @BindView(R2.id.btn_tips)
    QMUIAlphaButton btn_tips;
    @BindView(R2.id.btn_refund)
    QMUIAlphaButton btn_refund;
    @BindView(R2.id.btn_cancel_order)
    QMUIAlphaButton btn_cancel_order;
    @BindView(R2.id.btn_modify_order)
    QMUIAlphaButton btn_modify_order;

    @BindView(R2.id.ll_bottom)
    LinearLayout ll_bottom;
    @BindView(R2.id.tv_order_status)
    TextView tv_order_status;

    private OrderManagerResponse mOrderDetailItem;
    private List<OrderDetail> mOrderDetailList;

    private OrderCenterDetailFoodAdapter mOrderCenterDetailFoodAdapter;
    private List<SectionTextItem3> mOrderCenterDetailFoodList = new ArrayList<>();

    private OrderCenterMoneyAdapter mOrderCenterMoneyAdapter;
    private List<SectionTextItem3> mOrderCenterMoneyList = new ArrayList<>();

    private OrderCenterMoneyAdapter mOrderDetailPayMethodAdapter;
    private List<SectionTextItem3> mOrderCenterPayMethodList = new ArrayList<>();

    private DoshokuOrder mDoshokuOrder;
    private ShoppingCart mShoppingCart;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerOrderDetailComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_order_detail; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        mDoshokuOrder = DoshokuOrder.getInstance();
        mShoppingCart = mDoshokuOrder.getShoppingCart();
        super.onCreate(savedInstanceState);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        scrollview.post(new Runnable() {
            @Override
            public void run() {
                scrollview.scrollTo(0, 0);
            }
        });
        initOrderDetail(mOrderDetailItem);
    }

    private void initOrderDetail(OrderManagerResponse orderDetailItem) {
        if (orderDetailItem != null) {
            String payBill = LanguageUtils.get_language_system(this, "opentable.paybill", "結賬") + "：";
            String pax = LanguageUtils.get_language_system(this, "Meal.Mannumber", "人數") + "：";
            String openTable = LanguageUtils.get_language_system(this, "open.table", "開台") + "：";
            tv_people_num.setText(pax + orderDetailItem.getPerson());
            tv_open_time.setText(openTable + TimeUtils.getStringByFormat(new Date(orderDetailItem.getCreateTime()), TimeUtils.DEFAULT_DATE_FORMAT_YMDHM));
            if (!TextUtils.isEmpty(orderDetailItem.getEndTime())) {
                tv_pay_time.setText(payBill + TimeUtils.getStringByFormat(new Date(orderDetailItem.getEndTime()), TimeUtils.DEFAULT_DATE_FORMAT_YMDHM));
            }
            tv_total_money.setText("$" + orderDetailItem.getTotalAmount());

            setTitleByOrderType(orderDetailItem);
            setOrderStatus(orderDetailItem);
            setBtnVisibilityByOrderType(orderDetailItem);

            mOrderDetailList = OrderAssemblyUtil.assemblyOrder(OrderDetail.orderTransOrderDetails(orderDetailItem.getOrderDetails()));
            setOrderDetailAdapter(mOrderDetailList);

            double totalMoney = getTotalMoney();
            tv_total.setText("$" + totalMoney);

            setOrderMoneyAdpater(orderDetailItem, totalMoney);
            setOrderPayMethodAdapter(orderDetailItem);
        }
    }

    private void setOrderMoneyAdpater(OrderManagerResponse orderDetailItem, double totalMoney) {
        if (mOrderCenterMoneyList.size() > 0) {
            mOrderCenterMoneyList.clear();
        }
        SectionTextItem3 serviceAmountSection = getOrderServiceAmountSection(orderDetailItem);
        if (serviceAmountSection != null) {
            mOrderCenterMoneyList.add(serviceAmountSection);
        }
        List<SectionTextItem3> discountSections = getOrderDiscountSections(orderDetailItem);
        if (discountSections != null) {
            mOrderCenterMoneyList.addAll(discountSections);
        }
        SectionTextItem3 roudingSection = getOrderRoudingSection(orderDetailItem);
        if (roudingSection != null) {
            mOrderCenterMoneyList.add(roudingSection);
        }
        if (mOrderCenterMoneyAdapter == null) {
            mOrderCenterMoneyAdapter = new OrderCenterMoneyAdapter(mOrderCenterMoneyList);
            recycler_order_moeny.setAdapter(mOrderCenterMoneyAdapter);
            LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
            recycler_order_moeny.setLayoutManager(linearLayoutManager);
        } else {
            mOrderCenterMoneyAdapter.notifyDataSetChanged();
        }
    }

    private void setOrderDetailAdapter(List<OrderDetail> orderDetailList) {
        if (mOrderCenterDetailFoodAdapter == null) {
            mOrderCenterDetailFoodList.addAll(orderDetailTransSectionTextItem3(orderDetailList));
            mOrderCenterDetailFoodAdapter = new OrderCenterDetailFoodAdapter(mOrderCenterDetailFoodList);
            recycler_food.setAdapter(mOrderCenterDetailFoodAdapter);
            LinearLayoutManager allOrderRecycleLayoutManager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
            recycler_food.setLayoutManager(allOrderRecycleLayoutManager);
        } else {
            mOrderCenterDetailFoodList.clear();
            mOrderCenterDetailFoodList.addAll(orderDetailTransSectionTextItem3(orderDetailList));
            mOrderCenterDetailFoodAdapter.notifyDataSetChanged();
        }
    }

    private void setOrderPayMethodAdapter(OrderManagerResponse orderDetailItem) {
        List<PayMethod> payMethodList = getPayMethodList(orderDetailItem.getOrderPays());
        List<SectionTextItem3> sectionTextItem3List = orderPayMethodTransSectionTextItem3(payMethodList);
        if (mOrderDetailPayMethodAdapter == null) {
            mOrderCenterPayMethodList.addAll(sectionTextItem3List);
            mOrderDetailPayMethodAdapter = new OrderCenterMoneyAdapter(mOrderCenterPayMethodList);
            recycler_pay_method.setAdapter(mOrderDetailPayMethodAdapter);
            LinearLayoutManager allOrderRecycleLayoutManager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
            recycler_pay_method.setLayoutManager(allOrderRecycleLayoutManager);
        } else {
            mOrderCenterPayMethodList.clear();
            mOrderCenterPayMethodList.addAll(sectionTextItem3List);
            mOrderDetailPayMethodAdapter.notifyDataSetChanged();
        }
        //設置打印所需支付方式
        mDoshokuOrder.setBillMoney(payMethodList);
    }

    public static List<SectionTextItem3> orderPayMethodTransSectionTextItem3(List<PayMethod> payMethodList) {
        List<SectionTextItem3> sectionTextItem3List = new ArrayList<>();
        for (PayMethod payMethod : payMethodList) {
            SectionTextItem3 sectionTextItem3 = new SectionTextItem3();
            sectionTextItem3.setLeftText(payMethod.getPayName());
            sectionTextItem3.setCenterText(String.valueOf(0));
            sectionTextItem3.setRightText(String.valueOf(payMethod.getPayMoney()));
            sectionTextItem3.setLeftTextStyle(com.gingersoft.gsa.cloud.base.R.style.order_paymethod_text_style);
            sectionTextItem3.setRightTextStyle(com.gingersoft.gsa.cloud.base.R.style.order_paymethod_text_style);
            sectionTextItem3List.add(sectionTextItem3);
        }
        return sectionTextItem3List;
    }

    public static List<SectionTextItem3> orderDetailTransSectionTextItem3(List<OrderDetail> orderDetailList) {
        List<SectionTextItem3> sectionTextItem3List = new ArrayList<>();
        for (OrderDetail orderDetail : orderDetailList) {
            SectionTextItem3 sectionTextItem3 = new SectionTextItem3();
            String foodName;
            switch (orderDetail.getItemType()) {
                case 2:
                    foodName = "    " + orderDetail.getProductName();
                    break;
                case 3:
                    foodName = "       " + orderDetail.getProductName();
                    break;
                default:
                    foodName = orderDetail.getProductName();
                    break;
            }
            sectionTextItem3.setLeftText(foodName);
            sectionTextItem3.setCenterText(String.valueOf(orderDetail.getNumber()));
            sectionTextItem3.setRightText(String.valueOf(orderDetail.getPrice()));
            sectionTextItem3List.add(sectionTextItem3);
        }
        return sectionTextItem3List;
    }

    /**
     * 獲取支付方式
     *
     * @param orderPays
     * @return
     */
    private List<PayMethod> getPayMethodList(List<OrderManagerResponse.OrderPayBean> orderPays) {
        List<PayMethod> payMethodList = new ArrayList<>();
        if (orderPays != null) {
            for (OrderManagerResponse.OrderPayBean orderPayBean : orderPays) {
                PayMethod payMethod = new PayMethod();
                payMethod.setPayName(orderPayBean.getPayName());
                payMethod.setPayMoney(orderPayBean.getAmount());
                payMethodList.add(payMethod);
                if (orderPayBean.getTipsPrice() != 0) {
                    //打印添加找零或貼士行
                    String linePayType = orderPayBean.getLinePayType() == 1 ? "找零" : "貼士";
                    PayMethod payMethod2 = new PayMethod();
                    //這裡打印退一格
                    payMethod2.setPayName("     " + linePayType);
                    payMethod2.setPayMoney(orderPayBean.getTipsPrice());
                    payMethodList.add(payMethod2);
                }
            }
        }
        return payMethodList;
    }

    /**
     * 獲取賬單折扣列
     *
     * @param orderDetailItem
     * @return
     */
    private List<SectionTextItem3> getOrderDiscountSections(OrderManagerResponse orderDetailItem) {
        List<SectionTextItem3> sectionTextItem3s = null;
        if (orderDetailItem.getDiscountDetails() != null) {
            sectionTextItem3s = new ArrayList<>();
            //折扣
            for (OrderDiscountResponse discount : orderDetailItem.getDiscountDetails()) {
                sectionTextItem3s.add(discountTransSectionTextItem3(discount));
            }
        }
        return sectionTextItem3s;
    }

    private SectionTextItem3 discountTransSectionTextItem3(OrderDiscountResponse discount) {
        SectionTextItem3 sectionTextItem3 = new SectionTextItem3();
        sectionTextItem3.setLeftText(discount.getRemark());
        sectionTextItem3.setCenterText(String.valueOf(0));
        sectionTextItem3.setRightText(String.valueOf(discount.getDiscountAmount()));
        sectionTextItem3.setLeftTextStyle(com.gingersoft.gsa.cloud.base.R.style.order_paymethod_text_style);
        sectionTextItem3.setRightTextStyle(com.gingersoft.gsa.cloud.base.R.style.order_paymethod_text_style);
        return sectionTextItem3;
    }

    /**
     * 獲取賬單小數列
     *
     * @param orderDetailItem
     * @return
     */
    private SectionTextItem3 getOrderRoudingSection(OrderManagerResponse orderDetailItem) {
        if (orderDetailItem.getRounding() != null && orderDetailItem.getRounding() != 0) {
            return SectionTextItem3.roundingTransSectionTextItem3(orderDetailItem.getRounding());
        }
        return null;
    }

    /**
     * 获取服務費
     *
     * @param orderDetailItem
     * @return
     */
    private SectionTextItem3 getOrderServiceAmountSection(OrderManagerResponse orderDetailItem) {
        if (orderDetailItem.getServiceAmount() != null && orderDetailItem.getServiceAmount() != 0) {
            return SectionTextItem3.serviceAmountTransSectionTextItem3(orderDetailItem.getServiceAmount());
        }
        return null;
    }

    /**
     * 返回合計金額
     *
     * @return
     */
    private double getTotalMoney() {
        double otherMoney = 0.0;
        for (SectionTextItem3 item : mOrderCenterDetailFoodList) {
            otherMoney = MoneyUtil.sum(otherMoney, Double.parseDouble(item.getRightText()));
        }
        return otherMoney;
    }

    private void setTitleByOrderType(OrderManagerResponse item) {
        String orderCode = LanguageUtils.get_language_system(mContext, "order.code", "訂單碼") + ": ";
        String mealCode = LanguageUtils.get_language_system(mContext, "meal.code", "取餐碼") + ": ";
        if (item.getOrderType() == 2) {
            tv_table_name.setText("外賣");
            tv_order_num.setText(orderCode + item.getTakeFoodCode());
        } else if (item.getOrderType() == 7) {
            tv_table_name.setText("自取");
            tv_order_num.setText(orderCode + item.getBillNo() + "  " + mealCode + item.getTakeFoodCode());
        } else {
            String tableName = LanguageUtils.get_language_system(this, "table.number", "檯號") + ": ";
            String orderNumber = LanguageUtils.get_language_system(this, "order.number", "訂單號") + ": ";
            tv_table_name.setText(tableName + item.getTableName());
            tv_order_num.setText(orderNumber + item.getId());
        }
    }

    /**
     * 設置訂單狀態
     *
     * @param item
     */
    private void setOrderStatus(OrderManagerResponse item) {
        btn_cancel_order.setVisibility(View.GONE);
        if (item.getStatus() == 6) {
            btn_print_order.setVisibility(View.GONE);
            btn_modify_order.setVisibility(View.GONE);
//            btn_cancel_order.setVisibility(View.GONE);
            tv_order_status.setVisibility(View.VISIBLE);
        } else {
            btn_print_order.setVisibility(View.VISIBLE);
            btn_modify_order.setVisibility(View.VISIBLE);
//            btn_cancel_order.setVisibility(View.VISIBLE);
            tv_order_status.setVisibility(View.GONE);
        }
    }

    private void setBtnVisibilityByOrderType(OrderManagerResponse item) {
        if (item.getOrderType() == 2 || item.getOrderType() == 7) {
            //外賣自取 不可以修改訂單 取消訂單
            btn_modify_order.setVisibility(View.GONE);
            btn_cancel_order.setVisibility(View.GONE);
        }
    }

    @OnClick({R2.id.btn_print_order, R2.id.btn_cancel_order, R2.id.btn_modify_order})
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.btn_print_order) {
            startPrintOrder(mOrderDetailItem, mOrderDetailList);
        } else if (id == R.id.btn_cancel_order) {
            showCancelDialog();
        } else if (id == R.id.btn_modify_order) {
            startModifyOrder(mOrderDetailItem);
        }
    }

    private void startModifyOrder(OrderManagerResponse datasBean) {
        if (datasBean.getRestaurantTable() == null) {
            showMessage("餐檯不存在,無法修改訂單");
            return;
        }
        //設置為修改訂單操作
        mDoshokuOrder.setModifyOrder(true);
        /**
         * 緩存訂單信息
         */
        OrderResponse orderBean = new OrderResponse();
        orderBean.setId(datasBean.getId());
        orderBean.setStatus(datasBean.getStatus());
        orderBean.setOrderNo(datasBean.getOrderNo());
        orderBean.setPerson(datasBean.getPerson());
        orderBean.setCreateTime(datasBean.getCreateTime());
        orderBean.setOrderDetails(datasBean.getOrderDetails());
        if (datasBean.getDiscountDetails() != null) {
            orderBean.setDiscountDetails(datasBean.getDiscountDetails());
        }
        mDoshokuOrder.setOrderPlaced(orderBean);

        TableBean.DataBean tableBean = new TableBean.DataBean(datasBean.getRestaurantTable());
        if (!TextUtils.isEmpty(tableBean.getTableNumber())) {
            tableBean.setTableName(tableBean.getTableName() + "-" + tableBean.getTableNumber());
        } else {
            tableBean.setTableName(tableBean.getTableName());
        }
        tableBean.setPerson(datasBean.getPerson());
        mDoshokuOrder.setOpenTableInfo(tableBean);

        List<OrderResponse.OrderDetailsBean> orderDetailsBeans = datasBean.getOrderDetails();
        List<OrderDetail> orderDetailList = OrderAssemblyUtil.assemblyOrder(OrderDetail.orderTransOrderDetails(orderDetailsBeans));
        mDoshokuOrder.getShoppingCart().setOrderCommodityList(orderDetailList);

        if (datasBean.getMemberInfo() != null) {
            mDoshokuOrder.setMemberInfo(datasBean.getMemberInfo());
        }

        Intent intent = new Intent(this, MealStandActivity.class);
        startActivityForResult(intent, OrderCenterActivity.MODIFY_ORDER_RETURN_CODE);
    }

    /**
     * 打印賬單
     *
     * @param orderDetailItem
     * @param orderDetailList
     */
    private void startPrintOrder(OrderManagerResponse orderDetailItem, List<OrderDetail> orderDetailList) {
        mShoppingCart.setOrderCommodityList(orderDetailList);
        mShoppingCart.setBillItemList(getOrderMoneyList());
        mDoshokuOrder.setOrderId(orderDetailItem.getId());
        mShoppingCart.setWholeAmount(getTotalMoney());
        mShoppingCart.setTotalAmount(orderDetailItem.getTotalAmount());


        TableBean.DataBean dataBean = new TableBean.DataBean();
        dataBean.setTableName(orderDetailItem.getTableName());
        if (!TextUtils.isEmpty(orderDetailItem.getCreateTime())) {
            dataBean.setCreateTime(TimeUtils.getStringByFormat(new Date(orderDetailItem.getCreateTime()), TimeUtils.DEFAULT_DATE_FORMAT_YMDHM));
        }
        dataBean.setPerson(orderDetailItem.getPerson());
        mDoshokuOrder.setOpenTableInfo(dataBean);

        List<PayMethod> payMethodList = getPayMethodList(orderDetailItem.getOrderPays());
        if (payMethodList != null) {
            //設置打印所需支付方式
            mDoshokuOrder.setBillMoney(payMethodList);
        }
        if (orderDetailItem.getMemberInfo() != null) {
            mDoshokuOrder.setMemberInfo(orderDetailItem.getMemberInfo());
        } else {
            mDoshokuOrder.setIntegralQrcode(orderDetailItem.getVerifyCode());
        }

        CC.obtainBuilder("Component.Print")
                .setActionName("printActivity")
                .addParam(PrintConstans.PRINT_TYPE, PrintConstans.PRINT_BILL)
                .build()
                .callAsyncCallbackOnMainThread((cc, result) -> {
                    Log.e("error", "是否成功打印：" + result.isSuccess());
                    mDoshokuOrder.initialization();
                });
    }


    private ArrayList<BillItem> getOrderMoneyList() {
        ArrayList<BillItem> billOrderMoneyList = new ArrayList<>();
        if (mOrderCenterMoneyList != null) {
            for (SectionTextItem3 item : mOrderCenterMoneyList) {
                BillItem billItem = new BillOrderMoney();
                billItem.setName(item.getLeftText());
                billItem.setMoney(Double.parseDouble(item.getRightText()));
                billOrderMoneyList.add(billItem);
            }
        }
        return billOrderMoneyList;
    }

    private void showCancelDialog() {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(this);
        dialogBuilder.setTitle("溫馨提示");
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        dialogBuilder.setMessage("是否取消訂單?");
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            mPresenter.cancelOrder(mOrderDetailItem.getId());
        });
        dialogBuilder.addAction("取消", (dialog, index) -> dialog.dismiss());
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

    @Override
    public void initIntent() {
        Intent intent = getIntent();
        mOrderDetailItem = (OrderManagerResponse) intent.getSerializableExtra("orderDetailItem");
    }

    @Override
    public void initTopBar() {
        mTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        mTopBar.addLeftBackImageButton().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                killMyself();
//                overridePendingTransition(R.anim.slide_still, R.anim.slide_out_right);
            }
        });
        mTopBar.setTitle(LanguageUtils.get_language_system(this, "function.order.detail", "賬單詳情")).setTextColor(ArmsUtils.getColor(this, R.color.theme_white_color));
    }

    @Override
    public void initLanguage() {

        tv_food_detail_text.setText(LanguageUtils.get_language_system(this, "food.detail.text", "食品詳情"));
        tv_total_text.setText(LanguageUtils.get_language_system(this, "total.text", "合計"));
//        tv_server_money_text.setText(LanguageUtils.get_language_system(this, "service.fee.text", "服務費"));
        tv_total_money_text.setText(LanguageUtils.get_language_system(this, "order.countall_all", "總金額"));

        btn_print_order.setText(LanguageUtils.get_language_system(this, "print.order", "打印賬單"));
        btn_tips.setText(LanguageUtils.get_language_system(this, "public.tips", "貼士"));
        btn_modify_order.setText(LanguageUtils.get_language_system(this, "modify.order", "修改訂單"));
    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }


    @Override
    public void returnOrderDetail(OrderManagerResponse orderDetailItem) {
        this.mOrderDetailItem = orderDetailItem;
        initOrderDetail(orderDetailItem);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == OrderCenterActivity.MODIFY_ORDER_RETURN_CODE) {
            //修改訂單返回,刷新訂單數據
            mPresenter.getOrderDetailItem(mOrderDetailItem.getId());
        }
    }

}
