package com.gingersoft.gsa.cloud.account.user;

import com.gingersoft.gsa.cloud.account.user.info.UserInfo;
import com.gingersoft.gsa.cloud.account.user.state.UserState;
import lombok.Getter;
import lombok.Setter;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:用戶信息管理:如用戶登錄狀態，用戶信息等。。
 */
@Getter
@Setter
public class UserContextManger {

    private static UserContextManger userContextManger = null;

    /**
     * 用戶狀態
     */
    private UserState state;

    /**
     * 用戶信息
     */
    private UserInfo info;

    private UserContextManger() {
    }

    public static UserContextManger getInstance() {
        if (userContextManger == null) {
            synchronized (UserContextManger.class) {
                if (userContextManger == null) {
                    userContextManger = new UserContextManger();
                }
            }
        }
        return userContextManger;
    }

}
