package com.gingersoft.gsa.cloud.account.user.state;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.constans.PrintConstans;
import com.gingersoft.gsa.cloud.account.user.UserConstans;

/**
 * @author : bin
 * @create date: 2020-11-21
 * @update date: 2020-11-21
 * @description:用戶已登錄
 */
public class HasLoginState implements UserState{


    @Override
    public void toLoginPage() {
    }

    @Override
    public void logOut() {
        SPUtils.remove(UserConstans.token);
        SPUtils.remove(UserConstans.memberId);
        SPUtils.remove(UserConstans.brandId);
        SPUtils.remove(UserConstans.brandName);
        SPUtils.remove(UserConstans.restaurantId);
        SPUtils.remove(UserConstans.restaurantName);
        SPUtils.remove(UserConstans.memberName);
        SPUtils.remove(UserConstans.brandRestaurantInfos);
        SPUtils.remove(UserConstans.gsPosShopId);
        SPUtils.put(PrintConstans.IS_LOGIN, false);
        //关闭Prj打印服務
        CC.obtainBuilder("Component.Print")
                .setActionName("stopPrintService")
                .build()
                .call();
        //跳轉登陸頁面
        CC.obtainBuilder("User.Component.Login")
                .setActionName("showActivityA")
                .build()
                .call();
    }

    @Override
    public void toTargetPage() {

    }

}
