package com.gingersoft.gsa.cloud.config.globalconfig.lifecyclesOptioins;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.CommonConfiguration;
import com.gingersoft.gsa.cloud.database.utils.FoodComboDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.logan.LoganUtils;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.schedulers.Schedulers;


@SuppressLint("NewApi")
public class MyFragmentLifecycle extends FragmentManager.FragmentLifecycleCallbacks {

    @Override
    public void onFragmentAttached(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Context context) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentAttached");
    }

    @Override
    public void onFragmentCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentCreated");
    }

    @Override
    public void onFragmentActivityCreated(@NonNull FragmentManager fm, @NonNull Fragment f,
                                          @Nullable Bundle savedInstanceState) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentActivityCreated");
    }

    @Override
    public void onFragmentViewCreated(@NonNull FragmentManager fm, @NonNull Fragment f,
                                      @NonNull View v, @Nullable Bundle savedInstanceState) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentViewCreated");
    }

    @Override
    public void onFragmentStarted(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentStarted");
    }

    @Override
    public void onFragmentResumed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentResumed");
    }

    @Override
    public void onFragmentPaused(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentPaused");
    }

    @Override
    public void onFragmentStopped(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentStopped");
    }

    @Override
    public void onFragmentSaveInstanceState(@NonNull FragmentManager fm, @NonNull Fragment f,
                                            @NonNull Bundle outState) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentSaveInstanceState");
    }

    @Override
    public void onFragmentViewDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentViewDestroyed");
    }

    @Override
    public void onFragmentDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentDestroyed");
    }

    @Override
    public void onFragmentDetached(@NonNull FragmentManager fm, @NonNull Fragment f) {
        LoganUtils.w_action(f.getClass().getSimpleName() + ": onFragmentDetached");
    }
}
