package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import android.widget.SectionIndexer;

import com.chad.library.adapter.base.BaseDelegateMultiAdapter;
import com.chad.library.adapter.base.delegate.BaseMultiTypeDelegate;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.main.R;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/30
 * Time: 11:38
 * Use:
 */
public class FoodMenuMangerRightAdapter extends BaseDelegateMultiAdapter<Food, BaseViewHolder> implements SectionIndexer {

    private List<Food> foodGroups;
    private List<Food> foods;

    public final int TITLE = 1;
    public final int FOOD_INFO = 2;


    public FoodMenuMangerRightAdapter(List<Food> foodGroups, List<Food> foods) {
        super(foods);
        this.foods = foods;
        this.foodGroups = foodGroups;

        setMultiTypeDelegate(new BaseMultiTypeDelegate<Food>() {
            @Override
            public int getItemType(@NotNull List<? extends Food> list, int i) {
                if (list.get(i).getParentId() == 0) {
                    return TITLE;
                } else {
                    return FOOD_INFO;
                }
            }
        });
        getMultiTypeDelegate().
                addItemType(TITLE, R.layout.item_food_menu_category_title)
                .addItemType(FOOD_INFO, R.layout.item_food_menu_right_food_info);
    }

    @Override
    public Object[] getSections() {
        return foodGroups.toArray();
    }

    @Override
    public int getPositionForSection(int sectionIndex) {
        for (int i = 0; i < foods.size(); i++) {
            if (foods.get(i).getId().equals(foodGroups.get(sectionIndex).getId())) {
                return i;
            }
        }
        return -1;
    }

    @Override
    public int getSectionForPosition(int position) {
//        int i1 = foodGroups.indexOf(foods.get(position));
//        for (int i = 0; i < foodGroups.size(); i++) {
//            if (foods.get(position).getId().equals(foodGroups.get(i).getId())) {
//                return i;
//            }
//        }
        return foodGroups.indexOf(foods.get(position));
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, Food food) {
        if(baseViewHolder.getItemViewType() == FOOD_INFO){
            baseViewHolder.setText(R.id.item_food_menu_food_name, food.getFoodName());
        } else {
            baseViewHolder.setText(R.id.tv_food_menu_category_title, food.getFoodName());
        }
    }
}
