package com.gingersoft.gsa.cloud.base.order.discount;


import com.gingersoft.gsa.cloud.base.order.billItem.BillItem;

import lombok.Getter;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-19
 * 修订历史：2020-09-19
 * 描述: 折扣抽象類{@link MultyDiscount}
 */
@Getter
public abstract class MultyDiscount extends BillItem {

    /**責任鏈中的下一個對象*/
    protected MultyDiscount nextMultyDiscount;
    /**
     * 本次折扣金额
     */
    protected double discountMoney = 0.0;

    public MultyDiscount(String name,int status, MultyDiscount nextMultyDiscount) {
        super(name,status);
        this.nextMultyDiscount = nextMultyDiscount;
    }

    public double calculate(double money) {
        if (nextMultyDiscount != null) {
            return nextMultyDiscount.calculate(money);
        }
        return money;
    }
}
