package com.gingersoft.gsa.cloud.main.mvp.ui.fragment;

import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.os.Bundle;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.daivd.chart.component.axis.BaseAxis;
import com.daivd.chart.component.axis.HorizontalAxis;
import com.daivd.chart.component.axis.VerticalAxis;
import com.daivd.chart.component.base.IAxis;
import com.daivd.chart.core.LineChart;
import com.daivd.chart.data.ChartData;
import com.daivd.chart.data.LineData;
import com.daivd.chart.data.style.FontStyle;
import com.daivd.chart.data.style.LineStyle;
import com.daivd.chart.data.style.PointStyle;
import com.daivd.chart.listener.OnClickColumnListener;
import com.daivd.chart.provider.component.point.Point;
import com.daivd.chart.provider.component.tip.MultiLineBubbleTip;
import com.daivd.chart.utils.DensityUtils;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerMainTopComponent;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.HomeTurnoverBean;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.MainActivity;
import com.gingersoft.gsa.cloud.main.mvp.ui.view.CustomMarkView;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.main.mvp.contract.MainTopContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.MainTopPresenter;
import com.gingersoft.gsa.cloud.main.R;
import com.sxu.shadowdrawable.ShadowDrawable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import butterknife.BindView;
import butterknife.ButterKnife;
import static com.jess.arms.utils.Preconditions.checkNotNull;
import static com.qmuiteam.qmui.util.QMUIDisplayHelper.dpToPx;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/18/2020 17:21
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class MainTopFragment extends BaseFragment<MainTopPresenter> implements MainTopContract.View {
//    line_chart_view
    @BindView(R2.id.line_chart_view)
    LineChart lineChart;
    @BindView(R2.id.tv_today_amount)
    TextView tvTurnover;
    @BindView(R2.id.tv_today_time)
    TextView time;
    @BindView(R2.id.tv_total_amount_project)
    TextView tvProjectAmount;//項目總金額
    @BindView(R2.id.tv_consumers_number)
    TextView tvConsumersNumber;//消費人數
    @BindView(R2.id.tv_bill_number)
    TextView tvBillNumber;//賬單數
    public static MainTopFragment newInstance() {
        MainTopFragment fragment = new MainTopFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerMainTopComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_main_top, container, false);
        ButterKnife.bind(this, view);
        ShadowDrawable.setShadowDrawable(view.findViewById(R.id.cv_white_bg), Color.parseColor("#FFFFFF"), dpToPx(5),
                Color.parseColor("#73888888"), dpToPx(5), 0, 2);
        ShadowDrawable.setShadowDrawable(view.findViewById(R.id.layout_info), Color.parseColor("#FFFFFF"), dpToPx(5),
                Color.parseColor("#73888888"), dpToPx(5), 0, 2);

        return view;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        mPresenter.getRestaurantReport( "26");//GsaCloudApplication.getRestaurantId(mContext) 獲取餐廳營業信息
        time.setText(TimeUtils.getCurrentTimeInString(new SimpleDateFormat("YYYY-MM-dd E")));
        loadReport();//加載報表線形圖
    }

    private void loadReport() {

        Resources res = getResources();
        FontStyle.setDefaultTextSpSize(mContext, 12);

        List<String> chartYDataList = new ArrayList<>();
        chartYDataList.add("00:00");
        chartYDataList.add("04:00");
        chartYDataList.add("08:00");
        chartYDataList.add("12:00");
        chartYDataList.add("16:00");
        chartYDataList.add("20:00");
        chartYDataList.add("24:00");
        List<LineData> ColumnDatas = new ArrayList<>();
        //第一條線
        ArrayList<Double> tempList1 = new ArrayList<>();
        tempList1.add(12350d);
        tempList1.add(12340d);
        tempList1.add(2450d);
        tempList1.add(1470d);
        tempList1.add(1690d);
        tempList1.add(1570d);
        final LineData columnData1 = new LineData("今日", "℃", getResources().getColor(R.color.theme_color), tempList1);
        columnData1.setLineStyle(new LineStyle(mContext, 5, getResources().getColor(R.color.theme_color)));

        //第二條線
        ArrayList<Double> humidityList = new ArrayList<>();
        humidityList.add(1340d);
        humidityList.add(1320d);
        humidityList.add(480d);
        humidityList.add(590d);
        humidityList.add(360d);
        humidityList.add(1830d);
        humidityList.add(1980d);
        humidityList.add(1490d);
        LineData columnData2 = new LineData("昨日", "", getResources().getColor(R.color.today_line), humidityList);
        columnData2.setLineStyle(new LineStyle(mContext, 5, getResources().getColor(R.color.today_line)));
        ColumnDatas.add(columnData1);
        ColumnDatas.add(columnData2);

        ChartData<LineData> chartData2 = new ChartData<>("Line chart", chartYDataList, ColumnDatas);
        //設置曲線圖樣式
        lineChart.setLineModel(LineChart.CURVE_MODEL);
        //獲取左側垂直軸線
        VerticalAxis verticalAxis = lineChart.getLeftVerticalAxis();
        //獲取橫向軸線
        HorizontalAxis horizontalAxis = lineChart.getHorizontalAxis();
        //右側軸線
        VerticalAxis rightAxis = lineChart.getRightVerticalAxis();
        //設置右側軸線不顯示
        rightAxis.setDisplay(false);
        //设置竖轴方向在左側
        verticalAxis.setAxisDirection(IAxis.AxisDirection.LEFT);
        verticalAxis.setStartZero(true);
        verticalAxis.setMaxValue(18000);
        //设置网格
        verticalAxis.setDrawGrid(true);
        //设置横轴方向
        horizontalAxis.setAxisDirection(IAxis.AxisDirection.BOTTOM);
        //不顯示網格
        horizontalAxis.setDrawGrid(false);
        horizontalAxis.getAxisStyle().setWidth(mContext,1).setColor(res.getColor(R.color.theme_color));
        //设置线条样式
        verticalAxis.getAxisStyle().setWidth(mContext, 1).setColor(res.getColor(R.color.theme_color));
        //設置網格虛線樣式
        DashPathEffect effects = new DashPathEffect(new float[]{1, 2, 4, 8}, 1);
        verticalAxis.setGridStyle(new LineStyle(0.5f, res.getColor(R.color.report_dotted_line_color)));
        verticalAxis.getGridStyle().setEffect(effects);
        FontStyle scaleStyle = new FontStyle(mContext, 9, res.getColor(R.color.report_left_scale));
        scaleStyle.setScalePadding(30);
        horizontalAxis.setScaleStyle(scaleStyle);
        verticalAxis.setScaleStyle(scaleStyle);
        lineChart.setZoom(false);
        //开启十字架
        lineChart.getProvider().setOpenCross(true);
        //开启MarkView
//        lineChart.getProvider().setOpenMark(true);
        //设置MarkView
//        lineChart.getProvider().setMarkView(new CustomMarkView(mContext));
        //设置显示点
        Point point = new Point();
        point.getPointStyle().setShape(PointStyle.CIRCLE);
        //设置显示点的样式
        lineChart.getProvider().setPoint(point);
        //设置显示标题
        lineChart.setShowChartName(false);
        //底部不顯示顏色代表的意思
        lineChart.getLegend().setDisplay(false);
        lineChart.getMatrixHelper().setWidthMultiple(0.9f);
        lineChart.getHorizontalAxis().setRotateAngle(0);//設置底部文字旋轉角度
        lineChart.setFirstAnim(false);
        lineChart.setChartData(chartData2);
        lineChart.setOnClickColumnListener((lineData, pos) -> {
//            Paint paint = new Paint();
//            paint.setAntiAlias(true);
//            paint.setTextSize(DensityUtils.sp2px(mContext, 13));
//            paint.setStyle(Paint.Style.FILL);
//            paint.setColor(Color.WHITE);
//            MultiLineBubbleTip tip = new MultiLineBubbleTip<LineData>(mContext,
//                    R.mipmap.round_rect, R.mipmap.triangle, paint) {
//                @Override
//                public boolean isShowTip(LineData lineData, int position) {
//                    return position == pos;
//                }
//
//                @Override
//                public String[] format(LineData lineData, int position) {
//                    String title = lineData.getName();
//                    String value = lineData.getChartYDataList().get(position) + lineData.getUnit();
//                    return new String[]{title, value};
//                }
//            };
//            tip.setColorFilter(Color.parseColor("#FA8072"));
//            tip.setAlpha(0.8f);
//            lineChart.getProvider().setTip(tip);
//            lineChart.invalidate();
        });
    }

    /**
     * 通过此方法可以使 Fragment 能够与外界做一些交互和通信, 比如说外部的 Activity 想让自己持有的某个 Fragment 对象执行一些方法,
     * 建议在有多个需要与外界交互的方法时, 统一传 {@link Message}, 通过 what 字段来区分不同的方法, 在 {@link #setData(Object)}
     * 方法中就可以 {@code switch} 做不同的操作, 这样就可以用统一的入口方法做多个不同的操作, 可以起到分发的作用
     * <p>
     * 调用此方法时请注意调用时 Fragment 的生命周期, 如果调用 {@link #setData(Object)} 方法时 {Fragment#onCreate(Bundle)} 还没执行
     * 但在 {@link #setData(Object)} 里却调用了 Presenter 的方法, 是会报空的, 因为 Dagger 注入是在 {Fragment#onCreate(Bundle)} 方法中执行的
     * 然后才创建的 Presenter, 如果要做一些初始化操作,可以不必让外部调用 {@link #setData(Object)}, 在 {@link #initData(Bundle)} 中初始化就可以了
     * <p>
     * Example usage:
     * <pre>
     * public void setData(@Nullable Object data) {
     *     if (data != null && data instanceof Message) {
     *         switch (((Message) data).what) {
     *             case 0:
     *                 loadData(((Message) data).arg1);
     *                 break;
     *             case 1:
     *                 refreshUI();
     *                 break;
     *             default:
     *                 //do something
     *                 break;
     *         }
     *     }
     * }
     *
     * // call setData(Object):
     * Message data = new Message();
     * data.what = 0;
     * data.arg1 = 1;
     * fragment.setData(data);
     * </pre>
     *
     * @param data 当不需要参数时 {@code data} 可以为 {@code null}
     */
    @Override
    public void setData(@Nullable Object data) {

    }


    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }

    @Override
    public void loadBusinessInfo(Map<String, HomeTurnoverBean.DataBean> dataBeanMap) {
        HomeTurnoverBean.DataBean bean = dataBeanMap.get(TimeUtils.getCurrentTimeInString(TimeUtils.DATE_FORMAT_DATE));//TimeUtils.getCurrentTimeInString(TimeUtils.DATE_FORMAT_DATE)
        if (bean != null) {
            tvTurnover.setText(bean.getBusiness_amount());
            tvProjectAmount.setText(bean.getSales());
            tvConsumersNumber.setText(bean.getPeople());
            tvBillNumber.setText(bean.getNumber_bill());
        }


    }
}
