package com.gingersoft.gsa.other_order_mode.ui.activity

import android.app.Dialog
import android.os.Bundle
import android.widget.TextView
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil
import com.gingersoft.gsa.cloud.base.widget.DialogUtils
import com.gingersoft.gsa.cloud.print.bean.OrderDetails.DataBean
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.data.model.bean.BillBean
import com.gingersoft.gsa.other_order_mode.data.model.bean.PayTypeInfo
import com.gingersoft.gsa.other_order_mode.model.viewModel.PageViewModel
import com.gingersoft.gsa.other_order_mode.ui.adapter.FoodListAdapter
import com.gingersoft.gsa.other_order_mode.ui.adapter.PayBillAdapter
import com.gingersoft.gsa.other_order_mode.ui.base.BaseActivity
import com.gingersoft.gsa.other_order_mode.util.InjectorUtil
import kotlinx.android.synthetic.main.activity_pay.*

class PayActivity : BaseActivity() {

    private lateinit var pageViewModel: PageViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_pay)

        qm_order_pay_bar.setTitle("結賬")
        qm_order_pay_bar.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener { finish() }
        qm_order_pay_bar.setBackgroundColor(resources.getColor(R.color.theme_color))

        val orderDetails: DataBean = intent.getSerializableExtra("orderDetails") as DataBean

        pageViewModel = ViewModelProvider(this, InjectorUtil.getWeatherModelFactory())[PageViewModel::class.java]

        var foodCount = 0
        orderDetails.PRODUCT_NAME?.let { it ->
            rv_order_pay_food.layoutManager = LinearLayoutManager(this)
            rv_order_pay_food.adapter = FoodListAdapter(this, it)
            for (bean in it) {
                bean.child?.let { it ->
                    for (child in it) {
                        child.child?.let {
                            for (childBean in it) {
                                foodCount += childBean.num!!.toInt()
                            }
                        }
                        foodCount += child.num!!.toInt()
                    }
                }
                foodCount += bean.num!!.toInt()
            }
        }
        other_pay_view.loadInfo(this, ArrayList<PayMethod>(), MoneyUtil.sub(orderDetails.TOTAL_AMOUNT!!.toDouble(), orderDetails.discount_amount), foodCount)

        pageViewModel.getPayMethod(orderDetails.ID.toString())
        pageViewModel.payTypeBean.observe(this, Observer {
            //獲取支付方式
//            other_pay_view.loadInfo(this, PayTypeInfo.getPayMethodByPayType(it), MoneyUtil.sub(orderDetails.TOTAL_AMOUNT!!.toDouble(), orderDetails.discount_amount), foodCount)
            other_pay_view.notifyBillMethodAdapter(PayTypeInfo.getPayMethodByPayType(it))
        })
        other_pay_view.setmOnSureClickLisenter {payMethods->
            //確認結賬，調用結賬接口
            object : DialogUtils(this, R.layout.other_order_pause_orders) {
                override fun initLayout(hepler: ViewHepler, dialog: Dialog) {
                    hepler.setText(R.id.tv_warning_title, "是否確認結賬？")
                    hepler.getView<TextView>(R.id.tv_dialog_confirm).setOnClickListener {
                        dialog.dismiss()
                        showLoading()
                        pageViewModel.gsUpdateOrderStatus(orderDetails.ID.toString(), orderDetails.order_type, payMethods[0].id) { status, isSuccess ->
                            cancelDialogForLoading()
                            setResult(RESULT_OK)
                            finish()
                        }
                    }
                    hepler.getView<TextView>(R.id.tv_dialog_cancel).setOnClickListener {
                        dialog.dismiss()
                    }
                }
            }.show()
        }


        val billBeans = ArrayList<BillBean>()
        billBeans.add(BillBean("合計：", MoneyUtil.sub(MoneyUtil.sub(orderDetails.TOTAL_AMOUNT!!.toDouble(), orderDetails.Lunchbox), orderDetails.DELIVERY_CHARGE)))
        if (orderDetails.Lunchbox > 0) {
            billBeans.add(BillBean("餐盒費：", orderDetails.Lunchbox))
        }
        if (orderDetails.DELIVERY_CHARGE > 0) {
            billBeans.add(BillBean("送貨費：", orderDetails.DELIVERY_CHARGE))
        }
        if (orderDetails.discount_amount > 0) {
            billBeans.add(BillBean("折扣：", orderDetails.discount_amount, 1))
        }
        billBeans.add(BillBean("支付金額：", MoneyUtil.sub(orderDetails.TOTAL_AMOUNT!!.toDouble(), orderDetails.discount_amount)))
        rv_order_pay_bill.layoutManager = LinearLayoutManager(this)
        rv_order_pay_bill.adapter = PayBillAdapter(billBeans)

    }


}