package com.gingersoft.gsa.cloud.base.utils.other;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/7/5
 * 修订历史：2018/7/5
 * 描述：
 */

public class TextUtil {

    public static boolean isEmptyOrNullOrUndefined(String str) {
        return str == null || str.length() == 0 ||
                str.equals("null") || str.equals("undefined");
    }

    public static String isEmptyReturnString(String str) {
        if (str == null || str.length() == 0 ||
                str.equals("null") || str.equals("undefined")) {
            return "";
        } else {
            return str;
        }
    }

    public static int isEmptyReturnInt(Integer str) {
        if (str == null) {
            return 0;
        } else {
            return str;
        }
    }

    /**
     * 半角转换为全角
     *
     * @param input
     * @return
     */
    public static String ToDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; i++) {
            if (c[i] == 12288) {
                c[i] = (char) 32;
                continue;
            }
            if (c[i] > 65280 && c[i] < 65375)
                c[i] = (char) (c[i] - 65248);
        }
        return new String(c);
    }

    /**
     * 去除特殊字符或将所有中文标号替换为英文标号
     *
     * @param str
     * @return
     */
    public static String stringFilter(String str) {
        str = str.replaceAll("【", "[").replaceAll("】", "]")
                .replaceAll("！", "!").replaceAll("：", ":");// 替换中文标号
        String regEx = "[『』]"; // 清除掉特殊字符
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }
}
