package com.gingersoft.gsa.cloud.print.bean;

import android.os.Parcel;
import android.os.Parcelable;

import java.io.Serializable;

import lombok.Getter;
import lombok.Setter;

/**
 * @author : bin
 * @create date: 2020-11-06
 * @update date: 2020-11-06
 * @description:skyorder 打印實體
 * */
@Getter
@Setter
public class PrintQRCodeContent implements PrintContent, Parcelable {

    private String printTableName;
    private String printTopInfo;
    private String BottonInfo;
    private String printQrcode;
    private String printTime;
    private String printPeopleNum;
    private String printMealEndTime;
    private String printBottonInfo;



    public PrintQRCodeContent() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.printTableName);
        dest.writeString(this.printTopInfo);
        dest.writeString(this.BottonInfo);
        dest.writeString(this.printQrcode);
        dest.writeString(this.printTime);
        dest.writeString(this.printPeopleNum);
        dest.writeString(this.printMealEndTime);
        dest.writeString(this.printBottonInfo);
    }

    protected PrintQRCodeContent(Parcel in) {
        this.printTableName = in.readString();
        this.printTopInfo = in.readString();
        this.BottonInfo = in.readString();
        this.printQrcode = in.readString();
        this.printTime = in.readString();
        this.printPeopleNum = in.readString();
        this.printMealEndTime = in.readString();
        this.printBottonInfo = in.readString();
    }

    public static final Parcelable.Creator<PrintQRCodeContent> CREATOR = new Parcelable.Creator<PrintQRCodeContent>() {
        @Override
        public PrintQRCodeContent createFromParcel(Parcel source) {
            return new PrintQRCodeContent(source);
        }

        @Override
        public PrintQRCodeContent[] newArray(int size) {
            return new PrintQRCodeContent[size];
        }
    };
}
