package com.gingersoft.gsa.cloud.base.order.bean.discount;

import android.text.TextUtils;

import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-12
 * 修订历史：2020-09-12
 * 描述：优惠券折扣实体
 */
@Data
public class CouponDiscountBean {

    private Long id;
    // 店鋪ID
    private Long restaurantId;
    // 品牌ID
    private Long brandId;
    // 會員卡類型名稱
    private String couponTypeName1;
    // 會員卡類型名稱1
    private String couponTypeName2;
    private String couponTypeName3;
    // 優惠券的有效開始日期
    private String beginDate;
    // 優惠券的有效期結束日期
    private String endDate;
    // 有效天數
    private Integer periodDays;
    // 會員卡有效期
    private String periodDate;
    // 使用次數上限
    private Integer upperLimitTimes;
    // 卡類型：1折扣，2現金券
    private Byte couponType;
    // 卡規則狀態：0正常，1失效
    private Byte status;
    // 單詞消費上限金額// BigDecimal
    private Double billMinAmount;
    // 同一個訂單同一規則券的使用次數，小於等於1=只可用1次, 大於1=無限次
    private Integer samebillLimitTimes;
    // 是否獨佔 0否，1是
    private Byte exclusive;
    // 是否免費服務 0否，1是
    private Byte xSc;
    // 卡面值
    private double amount;
    // 卡折扣比列  8折：20'
    private int discount;
    // 備註
    private String remark;
    // 是否免會員積分 0否，1是
    private Byte xPoints;
    // 優惠券使用類型：1 不限制，2 app外賣,3 gspos，4外賣自取
    private Byte usageType;
    // 1 常規劵   2 無庫存劵3.口令領取
    private Byte isType;
    // 消費滿
    private Double spend;
    // 是否累計滿減：0否，1是
    private Byte accumulate;


    public String getName(){
        if(!TextUtils.isEmpty(couponTypeName1)) {
            return this.couponTypeName1;
        }
        if(!TextUtils.isEmpty(couponTypeName2)) {
            return this.couponTypeName2;
        }
        if(!TextUtils.isEmpty(couponTypeName3)) {
            return this.couponTypeName3;
        }
        return "";
    }

    /**
     * 計算優惠券金額
     * @param discount
     * @param amount
     * @param sourcePrice
     * @return
     */
    public static double calculationCoupon(double discount,double amount, double sourcePrice) {
        double discountPrice = 0;
        if (amount != 0) {
            //金額折扣
             discountPrice = amount;
        } else if(discount != 0){
            //百分比折扣
            discountPrice = MoneyUtil.divide(MoneyUtil.multiply(sourcePrice,discount), 100).doubleValue();
        }
        if (sourcePrice < discountPrice) {
            //折扣金額不能超出總額
            discountPrice = sourcePrice;
        }
        return -MoneyUtil.get_ItemDecimals_money(Math.abs(discountPrice));
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(Long restaurantId) {
        this.restaurantId = restaurantId;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getCouponTypeName1() {
        return couponTypeName1;
    }

    public void setCouponTypeName1(String couponTypeName1) {
        this.couponTypeName1 = couponTypeName1;
    }

    public String getCouponTypeName2() {
        return couponTypeName2;
    }

    public void setCouponTypeName2(String couponTypeName2) {
        this.couponTypeName2 = couponTypeName2;
    }

    public String getCouponTypeName3() {
        return couponTypeName3;
    }

    public void setCouponTypeName3(String couponTypeName3) {
        this.couponTypeName3 = couponTypeName3;
    }

    public String getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Integer getPeriodDays() {
        return periodDays;
    }

    public void setPeriodDays(Integer periodDays) {
        this.periodDays = periodDays;
    }

    public String getPeriodDate() {
        return periodDate;
    }

    public void setPeriodDate(String periodDate) {
        this.periodDate = periodDate;
    }

    public Integer getUpperLimitTimes() {
        return upperLimitTimes;
    }

    public void setUpperLimitTimes(Integer upperLimitTimes) {
        this.upperLimitTimes = upperLimitTimes;
    }

    public Byte getCouponType() {
        return couponType;
    }

    public void setCouponType(Byte couponType) {
        this.couponType = couponType;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Double getBillMinAmount() {
        return billMinAmount;
    }

    public void setBillMinAmount(Double billMinAmount) {
        this.billMinAmount = billMinAmount;
    }

    public Integer getSamebillLimitTimes() {
        return samebillLimitTimes;
    }

    public void setSamebillLimitTimes(Integer samebillLimitTimes) {
        this.samebillLimitTimes = samebillLimitTimes;
    }

    public Byte getExclusive() {
        return exclusive;
    }

    public void setExclusive(Byte exclusive) {
        this.exclusive = exclusive;
    }

    public Byte getxSc() {
        return xSc;
    }

    public void setxSc(Byte xSc) {
        this.xSc = xSc;
    }

    public double getAmount() {
        return amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public int getDiscount() {
        return discount;
    }

    public void setDiscount(int discount) {
        this.discount = discount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Byte getxPoints() {
        return xPoints;
    }

    public void setxPoints(Byte xPoints) {
        this.xPoints = xPoints;
    }

    public Byte getUsageType() {
        return usageType;
    }

    public void setUsageType(Byte usageType) {
        this.usageType = usageType;
    }

    public Byte getIsType() {
        return isType;
    }

    public void setIsType(Byte isType) {
        this.isType = isType;
    }

    public Double getSpend() {
        return spend;
    }

    public void setSpend(Double spend) {
        this.spend = spend;
    }

    public Byte getAccumulate() {
        return accumulate;
    }

    public void setAccumulate(Byte accumulate) {
        this.accumulate = accumulate;
    }
}
