package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.Gravity;
import android.widget.LinearLayout;
import com.gingersoft.gsa.cloud.base.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 上菜紙打印  已改新版
 */
public class PrintServe extends PrinterRoot {

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, printerDeviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String getPrintData(Context mContext, PrinterDeviceBean deviceBean) {
        List<OrderDetail> foodList = DoshokuOrder.getInstance().getShoppingCart().getOrderCommodityList();
        TableBean.DataBean tableBean = DoshokuOrder.getInstance().getOpenTableInfo();
        String stringBuilder = "<html><body>" +
                getHtmlPrintHeadInfo() +
                getHtmlPrintHeadOrderInfo(tableBean) +
                generateFoodInfoTwoColumns(foodList) +
                getWholeLine() +
                getHtmlFooter() + "</body></html>";
        return stringBuilder;
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }


    private Bitmap getBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {
        List<OrderDetail> foodList = DoshokuOrder.getInstance().getShoppingCart().getOrderCommodityList();
        if (foodList == null || foodList.size() <= 0) {
            return null;
        }
        TableBean.DataBean tableBean = DoshokuOrder.getInstance().getOpenTableInfo();

        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);

        //訂單頭
        layout.addView(getHeader(mContext));
        layout.addView(getLine(mContext));
        String orderNo = "單號：";
        if (TextUtil.isNotEmptyOrNullOrUndefined(DoshokuOrder.getInstance().getOrderNo())) {
            orderNo = "單號：" + DoshokuOrder.getInstance().getOrderNo();
        }
        //訂單信息
        layout.addView(getDiningTableOrderInfo(mContext, "餐檯：" + tableBean.getTableName(), "人數：" + DoshokuOrder.getInstance().getOpenTableInfo().getPerson(), orderNo, "日期：" + TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT)));
        layout.addView(getLine(mContext));

        layout.addView(getDiningFoodList(mContext, foodList, printerDeviceBean, 0, false));
        layout.addView(getLine(mContext));
        layout.addView(getTextView(mContext, "Thank you!", Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        layout.addView(getTextView(mContext, TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT), Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        return viewToZoomBitmap(mContext, layout, printerDeviceBean);
    }

}
