package com.gingersoft.gsa.cloud.table.mvp.model.table.action;

import android.app.Activity;
import android.content.Context;

import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.patterns.Strategy;
import com.gingersoft.gsa.cloud.table.mvp.ui.widget.SkyOrderDialog;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-23
 * 修订历史：2020-09-23
 * 描述：餐檯功能策略類，所有餐檯功能都需要繼承這個類
 */
@Data
public abstract class TableAction implements Strategy<TableBean.DataBean> {

    protected Activity mContext;
    protected String actionTitle;
    protected String actionHint;
    protected String actionContent;

    public TableAction(Activity context) {
        this.mContext = context;
    }

    public TableAction(Activity context, String actionTitle, String actionHint, String actionContent) {
        this.mContext = context;
        this.actionTitle = actionTitle;
        this.actionHint = actionHint;
        this.actionContent = actionContent;
    }

    /**
     * 不同餐檯操作，對餐檯的過濾條件
     */
    public abstract boolean filterTableCondition(TableBean.DataBean dataBean);

    public abstract void destroy();

    protected void setOperatContentText(String content) {
        if (actionListener != null) {
            actionListener.setOperatContentText(content);
        }
    }

    protected void resetTable(TableBean.DataBean tableBean) {
        if (actionListener != null) {
            actionListener.resetTable(tableBean);
        }
    }

    protected void moveTable(TableBean.DataBean tableBean) {
        if (actionListener != null) {
            actionListener.moveTable(tableBean);
        }
    }

    protected void showSplitTableDialogAction() {
        if (actionListener != null) {
            actionListener.showSplitTableDialogAction();
        }
    }

    protected void splitTableAction(TableBean.DataBean tableBean) {
        if (actionListener != null) {
            actionListener.splitTableAction(tableBean);
        }
    }

    public void cancel() {
        if (actionListener != null) {
            actionListener.cancel();
        }
    }

    private OnActionListener actionListener;

    public void setActionListener(OnActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public interface OnActionListener {
        void setOperatContentText(String content);

        void resetTable(TableBean.DataBean tableBean);

        void moveTable(TableBean.DataBean tableBean);

        void splitTableAction(TableBean.DataBean tableBean);

        void showSplitTableDialogAction();

        void cancel();
    }
}
