package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.res.ColorStateList;
import android.graphics.Color;
import android.text.TextUtils;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.FoodSummary;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem3;
import com.gingersoft.gsa.cloud.ui.view.ColorUtils;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.util.QMUIColorHelper;
import com.qmuiteam.qmui.widget.roundwidget.QMUIRoundButton;
import com.qmuiteam.qmui.widget.roundwidget.QMUIRoundButtonDrawable;

import java.util.List;

import butterknife.BindView;

/**
 * @author : bin
 * @create date: 2020-11-04
 * @update date: 2020-11-04
 * @description:
 */
public class FoodSummaryAdapter extends BaseQuickAdapter<FoodSummary, BaseViewHolder> {

    public FoodSummaryAdapter(@Nullable List<FoodSummary> data) {
        super(R.layout.table_item_food_summary, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, FoodSummary item) {
        QMUIRoundButton btn_summary = helper.getView(R.id.btn_summary);
        if (item.isSelected()) {
            btn_summary.setBackgroundColor(ArmsUtils.getColor(getContext(), R.color.theme_color));
            btn_summary.setStrokeColors(ColorStateList.valueOf(ArmsUtils.getColor(getContext(), R.color.theme_white_color)));
            btn_summary.setTextColor(ArmsUtils.getColor(getContext(), R.color.theme_white_color));
        } else {
            btn_summary.setBackgroundColor(ArmsUtils.getColor(getContext(), R.color.theme_white_color));
            btn_summary.setStrokeColors(ColorStateList.valueOf(ArmsUtils.getColor(getContext(), R.color.theme_text_color_black)));
            btn_summary.setTextColor(ArmsUtils.getColor(getContext(), R.color.theme_text_color_black));
        }
        if (!TextUtils.isEmpty(item.getName())) {
            btn_summary.setText(item.getName());
        }
    }

}