/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.aspectj.tools.ajdoc.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ajdoc
extends MatchingTask {
    public static final String AJDOC_CLASSNAME = "org.aspectj.tools.ajdoc.Main";
    public static final boolean FORCE_FORK = false;
    public static final boolean FORCE_FORK_VALUE = true;
    protected Commandline cmd;
    protected Commandline vmcmd;
    private Path sourcepath;
    private File destdir;
    private Collection<String> sourcefiles;
    private Collection<String> packagenames;
    private File packageList;
    private Path bootclasspath;
    private Path extdirs;
    private Path classpath;
    private Path internalclasspath;
    private List<File> argfiles;
    private Path docletpath;
    private Collection<Link> links;
    private Collection<Group> groups;
    private Doclet doclet;
    private boolean failonerror;
    private boolean fork;
    private String source;
    private Javadoc.Html bottom;
    private Vector<FileSet> fileSets = new Vector();

    public Ajdoc() {
        this.reset();
    }

    protected void reset() {
        this.cmd = new Commandline();
        this.vmcmd = new Commandline();
        this.sourcepath = null;
        this.destdir = null;
        this.sourcefiles = null;
        this.packagenames = null;
        this.packageList = null;
        this.bootclasspath = null;
        this.extdirs = null;
        this.classpath = null;
        this.internalclasspath = null;
        this.argfiles = null;
        this.docletpath = null;
        this.links = new ArrayList<Link>();
        this.groups = new ArrayList<Group>();
        this.doclet = null;
        this.failonerror = false;
        this.fork = false;
        this.source = null;
        this.bottom = null;
    }

    protected final boolean setif(boolean b, String flag) {
        if (b) {
            this.cmd.createArgument().setValue(flag);
        }
        return b;
    }

    protected final void setfile(String flag, String file) {
        this.set(flag, this.getProject().resolveFile(file).getAbsolutePath());
    }

    protected final void set(String flag, String val) {
        this.setif(true, flag, val);
    }

    protected final boolean setif(boolean b, String flag, String val) {
        if (this.setif(b, flag)) {
            this.cmd.createArgument().setValue(val);
        }
        return b;
    }

    public void setSource(String input) {
        this.source = input;
    }

    public void setSourcepath(Path path) {
        if (this.sourcepath == null) {
            this.sourcepath = path;
        } else {
            this.sourcepath.append(path);
        }
    }

    public Path createSourcepath() {
        return this.sourcepath == null ? (this.sourcepath = new Path(this.getProject())) : this.sourcepath.createPath();
    }

    public void setSourcepathRef(Reference id) {
        this.createSourcepath().setRefid(id);
    }

    public void setSrcdir(Path path) {
        this.setSourcepath(path);
    }

    public Path createSrcdir() {
        return this.createSourcepath();
    }

    public void setSrcdirRef(Reference id) {
        this.setSourcepathRef(id);
    }

    public void setDestdir(String destdir) {
        this.destdir = this.getProject().resolveFile(destdir);
    }

    public void setSourcefiles(String list) {
        (this.sourcefiles == null ? (this.sourcefiles = new ArrayList<String>()) : this.sourcefiles).addAll(this.strings(list));
    }

    public void addFileset(FileSet fs) {
        this.fileSets.addElement(fs);
    }

    private void addFileSets() {
        if (this.sourcefiles == null) {
            this.sourcefiles = new ArrayList<String>();
        }
        Enumeration<FileSet> e = this.fileSets.elements();
        while (e.hasMoreElements()) {
            FileSet fs = e.nextElement();
            if (!fs.hasPatterns() && !fs.hasSelectors()) {
                fs = (FileSet)fs.clone();
                fs.createInclude().setName("**/*.java");
                fs.createInclude().setName("**/*.aj");
            }
            File baseDir = fs.getDir(this.getProject());
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                this.sourcefiles.add(new File(baseDir, files[i]).getAbsolutePath());
            }
        }
    }

    public void setPackagenames(String list) {
        (this.packagenames == null ? (this.packagenames = new ArrayList<String>()) : this.packagenames).addAll(this.strings(list, true));
    }

    public void setAccess(Javadoc.AccessType at) {
        this.cmd.createArgument().setValue("-" + at.getValue());
    }

    public void setPackageList(String packageList) {
        this.packageList = this.getProject().resolveFile(packageList);
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        return (this.classpath == null ? (this.classpath = new Path(this.getProject())) : this.classpath).createPath();
    }

    public void setClasspathref(Reference id) {
        this.createClasspath().setRefid(id);
    }

    public void setBootclasspath(Path path) {
        if (this.bootclasspath == null) {
            this.bootclasspath = path;
        } else {
            this.bootclasspath.append(path);
        }
    }

    public Path createBootclasspath() {
        return (this.bootclasspath == null ? (this.bootclasspath = new Path(this.getProject())) : this.bootclasspath).createPath();
    }

    public void setBootclasspathref(Reference bootclasspathref) {
        this.createBootclasspath().setRefid(bootclasspathref);
    }

    public void setInternalclasspath(Path internalclasspath) {
        if (this.internalclasspath == null) {
            this.internalclasspath = internalclasspath;
        } else {
            this.internalclasspath.append(internalclasspath);
        }
    }

    public Path createInternalclasspath() {
        if (this.internalclasspath == null) {
            this.internalclasspath = new Path(this.getProject());
        }
        return this.internalclasspath.createPath();
    }

    public void setInternalclasspathref(Reference internalclasspathref) {
        this.createInternalclasspath().setRefid(internalclasspathref);
    }

    public void setExtdirs(Path path) {
        if (this.extdirs == null) {
            this.extdirs = path;
        } else {
            this.extdirs.append(path);
        }
    }

    public List<File> createArgfiles() {
        return this.argfiles == null ? (this.argfiles = new ArrayList<File>()) : this.argfiles;
    }

    public void setArgfile(String argfile) {
        this.createArgfiles().add(this.getProject().resolveFile(argfile));
    }

    public void setArgfiles(String argfiles) {
        this.createArgfiles().addAll(this.files(argfiles));
    }

    public void setOverview(String overview) {
        this.setfile("-overview", overview);
    }

    public void setPublic(boolean b) {
        this.setif(b, "-public");
    }

    public void setPackage(boolean b) {
        this.setif(b, "-package");
    }

    public void setProtected(boolean b) {
        this.setif(b, "-protected");
    }

    public void setPrivate(boolean b) {
        this.setif(b, "-private");
    }

    public void setOld(boolean old) {
        this.setif(old, "-old");
    }

    public void setAuthor(boolean author) {
        this.setif(author, "-author");
    }

    public void setSplitindex(boolean splitindex) {
        this.setif(splitindex, "-splitindex");
    }

    public void setWindowtitle(String windowtitle) {
        this.set("-windowtitle", windowtitle);
    }

    public void setDoctitle(String doctitle) {
        this.set("-doctitle", doctitle);
    }

    public void setHeader(String header) {
        this.set("-header", header);
    }

    public void setFooter(String footer) {
        this.set("-footer", footer);
    }

    public void setBottom(String bottom) {
        Javadoc.Html html = new Javadoc.Html();
        html.addText(bottom);
        this.addBottom(html);
    }

    public void addBottom(Javadoc.Html text) {
        this.bottom = text;
    }

    public void setVerbose(boolean b) {
        this.setif(b, "-verbose");
    }

    public void setVersion(boolean b) {
        this.setif(b, "-version");
    }

    public void setUse(boolean b) {
        this.setif(b, "-use");
    }

    public void setStandard(boolean b) {
        this.setif(b, "-standard");
    }

    public void setLink(String href) {
        this.createLink().setHref(href);
    }

    public Link createLink() {
        Link link = new Link();
        this.links.add(link);
        return link;
    }

    public void setLinkoffline(String linkoffline) {
        Link link = this.createLink();
        int ispace = linkoffline.indexOf(" ");
        if (ispace == -1) {
            throw new BuildException("linkoffline usage: <url> <url2>!", this.getLocation());
        }
        link.setHref(linkoffline.substring(0, ispace).trim());
        link.setPackagelistLoc(linkoffline.substring(ispace + 1).trim());
    }

    public void setGroup(String str) {
        StringTokenizer t = new StringTokenizer(str, ",", false);
        while (t.hasMoreTokens()) {
            String s = t.nextToken().trim();
            int ispace = s.indexOf(32);
            if (ispace != -1) {
                Group group = this.createGroup();
                group.setTitle(s.substring(0, ispace));
                group.setPackagenames(s.substring(ispace + 1));
                continue;
            }
            throw new BuildException("group usage: group=[<title> <pkglist>]*", this.getLocation());
        }
    }

    public Group createGroup() {
        Group group = new Group();
        this.groups.add(group);
        return group;
    }

    public void setNodeprecated(boolean nodeprecated) {
        this.setif(nodeprecated, "-nodeprecated");
    }

    public void setNodeprecatedlist(boolean nodeprecatedlist) {
        this.setif(nodeprecatedlist, "-nodeprecatedlist");
    }

    public void setNotree(boolean notree) {
        this.setif(notree, "-notree");
    }

    public void setNoindex(boolean noindex) {
        this.setif(noindex, "-noindex");
    }

    public void setNohelp(boolean nohelp) {
        this.setif(nohelp, "-nohelp");
    }

    public void setNonavbar(boolean nonavbar) {
        this.setif(nonavbar, "-nonavbar");
    }

    public void setSerialwarn(boolean serialwarn) {
        this.setif(serialwarn, "-serialwarn");
    }

    public void setHelpfile(String helpfile) {
        this.setfile("-helpfile", helpfile);
    }

    public void setStylesheetfile(String stylesheetfile) {
        this.setfile("-stylesheetfile", stylesheetfile);
    }

    public void setCharset(String charset) {
        this.set("-charset", charset);
    }

    public void setDocencoding(String docencoding) {
        this.set("-docencoding", docencoding);
    }

    public void setDoclet(String doclet) {
        this.createDoclet().setName(doclet);
    }

    public Doclet createDoclet() {
        if (this.doclet != null) {
            throw new BuildException("Only one doclet is allowed!");
        }
        this.doclet = new Doclet();
        return this.doclet;
    }

    public void setDocletpath(Path path) {
        (this.docletpath == null ? (this.docletpath = path) : this.docletpath).append(path);
    }

    public Path createDocletpath() {
        return this.docletpath == null ? (this.docletpath = new Path(this.getProject())) : this.docletpath.createPath();
    }

    public void setDocletpathRef(Reference id) {
        this.createDocletpath().setRefid(id);
    }

    public void setAdditionalparam(String additionalparam) {
        this.cmd.createArgument().setLine(additionalparam);
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public Commandline.Argument createJvmarg() {
        return this.vmcmd.createArgument();
    }

    public void setMaxmemory(String max) {
        this.createJvmarg().setValue((Project.getJavaVersion().startsWith("1.1") ? "-mx" : "-Xmx") + max);
    }

    public void execute() throws BuildException {
        Iterator<Object> i;
        ArrayList packages;
        if (this.sourcepath == null && this.argfiles == null && this.fileSets.size() == 0) {
            throw new BuildException("one of sourcepath or argfiles must be set!", this.getLocation());
        }
        if (this.sourcepath != null) {
            this.cmd.createArgument().setValue("-sourcepath");
            this.cmd.createArgument().setPath(this.sourcepath);
        }
        if (this.destdir != null) {
            this.cmd.createArgument().setValue("-d");
            this.cmd.createArgument().setFile(this.destdir);
        }
        if (this.classpath != null) {
            this.cmd.createArgument().setValue("-classpath");
            this.cmd.createArgument().setPath(this.classpath);
        }
        if (this.bootclasspath != null) {
            this.cmd.createArgument().setValue("-bootclasspath");
            this.cmd.createArgument().setPath(this.bootclasspath);
        }
        if (this.extdirs != null) {
            this.cmd.createArgument().setValue("-extdirs");
            this.cmd.createArgument().setPath(this.extdirs);
        }
        if (this.source != null) {
            this.cmd.createArgument().setValue("-source");
            this.cmd.createArgument().setValue(this.source);
        }
        if (this.bottom != null) {
            this.cmd.createArgument().setValue("-bottom");
            this.cmd.createArgument().setValue(this.getProject().replaceProperties(this.bottom.getText()));
        }
        for (Link link : this.links) {
            if (link.href == null) {
                throw new BuildException("Link href cannot be null!", this.getLocation());
            }
            if (link.packagelistLoc != null) {
                this.cmd.createArgument().setValue("-linkoffline");
                this.cmd.createArgument().setValue(link.href);
                this.cmd.createArgument().setValue(link.packagelistLoc);
                continue;
            }
            this.cmd.createArgument().setValue("-link");
            this.cmd.createArgument().setValue(link.href);
        }
        if (this.doclet != null) {
            if (this.doclet.name == null) {
                throw new BuildException("Doclet name cannot be null!", this.getLocation());
            }
            this.cmd.createArgument().setValue("-doclet");
            this.cmd.createArgument().setValue(this.doclet.name);
            if (this.doclet.path != null) {
                this.cmd.createArgument().setValue("-docletpath");
                this.cmd.createArgument().setPath(this.doclet.path);
            }
            for (Param param : this.doclet.params) {
                if (param.name == null) {
                    throw new BuildException("Doclet params cannot be null!", this.getLocation());
                }
                this.cmd.createArgument().setValue(param.name);
                if (param.value != null) continue;
                this.cmd.createArgument().setValue(param.value);
            }
        }
        HashMap groupMap = new HashMap();
        for (Group group : this.groups) {
            if (group.title == null) {
                throw new BuildException("Group names cannot be null!", this.getLocation());
            }
            if (group.packages == null) {
                throw new BuildException("Group packages cannot be null!", this.getLocation());
            }
            packages = (ArrayList)groupMap.get(group.title);
            if (packages == null) {
                packages = new ArrayList();
            }
            packages.addAll(group.packages);
            groupMap.put(group.title, packages);
        }
        for (String title : groupMap.keySet()) {
            packages = (List)groupMap.get(title);
            String pkgstr = "";
            Iterator j = packages.iterator();
            while (j.hasNext()) {
                pkgstr = pkgstr + (String)j.next();
                if (!j.hasNext()) continue;
                pkgstr = pkgstr + ",";
            }
            this.cmd.createArgument().setValue("-group");
            this.cmd.createArgument().setValue(title);
            this.cmd.createArgument().setValue(pkgstr);
        }
        if (this.argfiles != null) {
            i = this.argfiles.iterator();
            while (i.hasNext()) {
                String name = i.next() + "";
                File argfile = this.getProject().resolveFile(name);
                if (!this.check(argfile, name, false, this.getLocation())) continue;
                this.cmd.createArgument().setValue("-argfile");
                this.cmd.createArgument().setFile(argfile);
            }
        }
        if (this.packageList != null) {
            this.cmd.createArgument().setValue("@" + this.packageList);
        }
        if (null != this.packagenames) {
            i = this.packagenames.iterator();
            while (i.hasNext()) {
                this.cmd.createArgument().setValue((String)i.next());
            }
        }
        int numfiles = 0;
        if (this.sourcepath != null) {
            String[] dirs = this.sourcepath.list();
            for (int i2 = 0; i2 < dirs.length; ++i2) {
                File dir = this.getProject().resolveFile(dirs[i2]);
                this.check(dir, dirs[i2], true, this.getLocation());
                String[] files = this.getDirectoryScanner(dir).getIncludedFiles();
                for (int j = 0; j < files.length; ++j) {
                    File file = new File(dir, files[j]);
                    if (!file.getName().endsWith(".java") && !file.getName().endsWith(".aj")) continue;
                    this.cmd.createArgument().setFile(file);
                    ++numfiles;
                }
            }
        }
        this.addFileSets();
        if (this.sourcefiles != null) {
            Iterator<String> i3 = this.sourcefiles.iterator();
            while (i3.hasNext()) {
                this.cmd.createArgument().setValue(i3.next());
            }
        }
        int result = this.compile();
        if (this.failonerror && 0 != result) {
            throw new BuildException("Ajdoc failed with code " + result);
        }
        this.reset();
    }

    protected int compile() throws BuildException {
        try {
            String[] args = this.cmd.getArguments();
            if (this.fork) {
                this.log("Warning: fork is ignored ", 1);
            }
            Main.main(args);
            if (Main.hasAborted()) {
                return 1;
            }
            return 0;
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    protected final <T> List<T> list(String str, Mapper<T> mapper) {
        if (str == null) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>();
        StringTokenizer t = new StringTokenizer(str, ",", false);
        while (t.hasMoreTokens()) {
            list.add(mapper.map(t.nextToken().trim()));
        }
        return list;
    }

    protected final List<File> files(String str) {
        return this.list(str, new Mapper<File>(){

            @Override
            public File map(String s) {
                return Ajdoc.this.getProject().resolveFile(s);
            }
        });
    }

    protected final List<String> strings(String str) {
        return this.strings(str, false);
    }

    protected final List<String> strings(String str, final boolean filterSlashes) {
        return this.list(str, new Mapper<String>(){

            @Override
            public String map(String s) {
                return filterSlashes ? Ajdoc.this.filterSlashes(s) : s;
            }
        });
    }

    protected final String filterSlashes(String str) {
        if (str == null) {
            return null;
        }
        return str.replace('/', '.').replace('\\', '.').replace(File.separatorChar, '.');
    }

    protected final boolean check(File file, String name, boolean isDir, Location loc) {
        Location location = loc = loc != null ? loc : this.getLocation();
        if (file == null) {
            throw new BuildException(name + " is null!", loc);
        }
        if (!file.exists()) {
            throw new BuildException(file + "doesn't exist!", loc);
        }
        if (isDir ^ file.isDirectory()) {
            throw new BuildException(file + " should" + (!isDir ? "n't" : "") + " be a directory!", loc);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Mapper<T> {
        public T map(String var1);
    }

    public class Doclet {
        protected String name;
        protected Path path;
        protected List<Param> params = new ArrayList<Param>();

        public void setName(String name) {
            this.name = name;
        }

        public void setPath(Path path) {
            if (this.path == null) {
                this.path = path;
            } else {
                this.path.append(path);
            }
        }

        public Path createPath() {
            return (this.path == null ? (this.path = new Path(Ajdoc.this.getProject())) : this.path).createPath();
        }

        public Param createParam() {
            Param param = new Param();
            this.params.add(param);
            return param;
        }
    }

    public static class Param {
        protected String name;
        protected String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class Group {
        private String title;
        private List<String> packages;

        public void setTitle(String title) {
            this.title = title;
        }

        public final void setPackages(String packages) {
            this.setPackagenames(packages);
        }

        public void setPackagenames(String packages) {
            this.packages = Ajdoc.this.strings(packages);
        }
    }

    public class Link {
        protected String href;
        protected boolean offline;
        protected String packagelistLoc;

        public void setHref(String href) {
            this.href = href;
        }

        public void setOffline(boolean offline) {
            this.offline = offline;
        }

        public void setPackagelistLoc(String packagelistLoc) {
            this.packagelistLoc = packagelistLoc;
        }
    }
}

