/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import jcifs.smb.DosError;
import jcifs.smb.NtStatus;
import jcifs.smb.WinError;
import jcifs.util.Hexdump;

public class SmbException
extends IOException
implements NtStatus,
DosError,
WinError {
    private int status;
    private Throwable rootCause;

    static String getMessageByCode(int errcode) {
        if (errcode == 0) {
            return "NT_STATUS_SUCCESS";
        }
        if ((errcode & 0xC0000000) == -1073741824) {
            int min = 1;
            int max = NT_STATUS_CODES.length - 1;
            while (max >= min) {
                int mid = (min + max) / 2;
                if (errcode > NT_STATUS_CODES[mid]) {
                    min = mid + 1;
                    continue;
                }
                if (errcode < NT_STATUS_CODES[mid]) {
                    max = mid - 1;
                    continue;
                }
                return NT_STATUS_MESSAGES[mid];
            }
        } else {
            int min = 0;
            int max = DOS_ERROR_CODES.length - 1;
            while (max >= min) {
                int mid = (min + max) / 2;
                if (errcode > DOS_ERROR_CODES[mid][0]) {
                    min = mid + 1;
                    continue;
                }
                if (errcode < DOS_ERROR_CODES[mid][0]) {
                    max = mid - 1;
                    continue;
                }
                return DOS_ERROR_MESSAGES[mid];
            }
        }
        return "0x" + Hexdump.toHexString(errcode, 8);
    }

    static int getStatusByCode(int errcode) {
        if ((errcode & 0xC0000000) != 0) {
            return errcode;
        }
        int min = 0;
        int max = DOS_ERROR_CODES.length - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            if (errcode > DOS_ERROR_CODES[mid][0]) {
                min = mid + 1;
                continue;
            }
            if (errcode < DOS_ERROR_CODES[mid][0]) {
                max = mid - 1;
                continue;
            }
            return DOS_ERROR_CODES[mid][1];
        }
        return -1073741823;
    }

    static String getMessageByWinerrCode(int errcode) {
        int min = 0;
        int max = WINERR_CODES.length - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            if (errcode > WINERR_CODES[mid]) {
                min = mid + 1;
                continue;
            }
            if (errcode < WINERR_CODES[mid]) {
                max = mid - 1;
                continue;
            }
            return WINERR_MESSAGES[mid];
        }
        return errcode + "";
    }

    SmbException() {
    }

    SmbException(int errcode, Throwable rootCause) {
        super(SmbException.getMessageByCode(errcode));
        this.status = SmbException.getStatusByCode(errcode);
        this.rootCause = rootCause;
    }

    SmbException(String msg) {
        super(msg);
        this.status = -1073741823;
    }

    SmbException(String msg, Throwable rootCause) {
        super(msg);
        this.rootCause = rootCause;
        this.status = -1073741823;
    }

    public SmbException(int errcode, boolean winerr) {
        super(winerr ? SmbException.getMessageByWinerrCode(errcode) : SmbException.getMessageByCode(errcode));
        this.status = winerr ? errcode : SmbException.getStatusByCode(errcode);
    }

    public int getNtStatus() {
        return this.status;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String toString() {
        if (this.rootCause != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.rootCause.printStackTrace(pw);
            return super.toString() + "\n" + sw;
        }
        return super.toString();
    }
}

