package com.gingersoft.supply_chain.mvp.ui.fragment.warehouse;

import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.component.DaggerWarehousingOrderListComponent;
import com.gingersoft.supply_chain.mvp.contract.WarehousingOrderListContract;
import com.gingersoft.supply_chain.mvp.presenter.WarehousingOrderListPresenter;

import com.gingersoft.supply_chain.R;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/28/2021 19:21
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class WarehousingOrderListFragment extends BaseSupplyChainFragment<WarehousingOrderListPresenter> implements WarehousingOrderListContract.View {

    public static WarehousingOrderListFragment newInstance() {
        WarehousingOrderListFragment fragment = new WarehousingOrderListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerWarehousingOrderListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_warehousing_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

    }
}
