package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.ComboItemDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.FineItemOneselfContract;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.MealStyleUtils;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import java.util.List;

import javax.inject.Inject;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/19/2020 22:16
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class FineItemOneselfModel extends BaseModel implements FineItemOneselfContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public FineItemOneselfModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public List<Modifier> queryDB_ModifierList(long fid, int mode) {
        ModifierDaoUtils daoUtils = new ModifierDaoUtils(mApplication);
        return MealStyleUtils.assemblyModifiersColor(daoUtils.queryModifiersByFid(fid, mode));
    }

    @Override
    public List<ComboItem> queryDB_ComboList(long fid) {
        ComboItemDaoUtils comboItemDao = new ComboItemDaoUtils(mApplication);
        List<ComboItem> foodCombo = comboItemDao.queryComboItemsByFidQueryBuilder(fid,null);
        return foodCombo;
    }
}