package com.gingersoft.gsa.other_order_mode.ui.fragment

import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.model.viewModel.PageViewModel
import com.gingersoft.gsa.other_order_mode.ui.adapter.OtherOrdersAdapter
import com.gingersoft.gsa.other_order_mode.ui.base.BaseFragment
import com.gingersoft.gsa.other_order_mode.util.InjectorUtil
import com.gingersoft.gsa.other_order_mode.util.OtherOrderUtils
import com.scwang.smartrefresh.layout.header.BezierRadarHeader
import com.scwang.smartrefresh.layout.header.FalsifyHeader
import kotlinx.android.synthetic.main.fragment_other_order.*

/**
 * A placeholder fragment containing a simple view.
 */
class PlaceholderFragment : BaseFragment() {

    private lateinit var pageViewModel: PageViewModel
    private var page = 1

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        pageViewModel = ViewModelProvider(activity?.viewModelStore!!, InjectorUtil.getWeatherModelFactory())[PageViewModel::class.java].apply {
            // 第一次進入獲取數據
            getOrderList(this, false)
            // 綁定狀態，如果這個值發生變化
            refreshState.observe(viewLifecycleOwner, Observer {
                // 觸發刷新，判斷是否更新
                // 並且type一致
                //如果當前fragment的狀態中包含需要刷新的狀態，獲取數據
                Log.e("eee", "$it,當前fragment的" + PageViewModel.fragmentStatus[arguments?.getInt(INDEX)!!])
                // if (PageViewModel.fragmentStatus[arguments?.getInt(INDEX)!!].contains(it.toString())) {
                getOrderList(this, false)
                // }
            })
        }

        // 初始化recyclerview
        rv_other_order.layoutManager = LinearLayoutManager(activity)
        val adapter = OtherOrdersAdapter(activity!!)

        adapter.setOnItemClickListenter { data ->
            // 點擊查詢食品詳情
            showLoading()
            pageViewModel.getOrderInfo(data.Id.toString()) { it1 ->
                //顯示彈窗
                cancelDialogForLoading()
                if (this@PlaceholderFragment.context != null && it1 != null) {
                    OtherOrderUtils.showOrderDetailsDialog(this@PlaceholderFragment.context!!, it1, data.STATUS, data.order_type) { _, dialog ->
                        pageViewModel.updateOrderStatus(this@PlaceholderFragment.context!!, data, it1) {
                            dialog.dismiss()
                            if (it) {
                                // 關閉彈窗，並刷新頁面
                                refresh()
                            }
                        }
                    }
                }
            }
        }
        rv_other_order.adapter = adapter
        while (pageViewModel.mOrderList.size <= arguments?.getInt(INDEX)!!) {
            pageViewModel.mOrderList.add(MutableLiveData())
        }
        // 綁定當前fragment的數據項
        pageViewModel.mOrderList[arguments?.getInt(INDEX)!!].observe(viewLifecycleOwner, Observer {
            it.let { adapter.setData(it) }
        })

        // 设置 Header 顏色
        refresh_layout.setPrimaryColorsId(R.color.color_f0, R.color.color_66)
        // 下拉刷新，加載更多
        refresh_layout.setOnRefreshListener {
            refresh()
        }

        refresh_layout.setOnLoadMoreListener {
            page++
            getOrderList(pageViewModel, true)
        }
    }

    private fun refresh() {
        page = 0
        pageViewModel.orderNo = ""
        pageViewModel.phone = ""
        getOrderList(pageViewModel, false)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_other_order, container, false)
    }

    private fun getOrderList(pageViewModel: PageViewModel, isLoadMore: Boolean) {
        pageViewModel.getOrderList(arguments?.getInt(INDEX) ?: 0, page.toString(), isLoadMore) {
            refresh_layout.finishRefresh()
            refresh_layout.finishLoadMore()
        }
    }

    companion object {
        private const val INDEX = "index"
        @JvmStatic
        fun newInstance(position: Int): PlaceholderFragment {
            return PlaceholderFragment().apply {
                arguments = Bundle().apply {
                    putInt(INDEX, position)
                }
            }
        }
    }
}