package com.gingersoft.gsa.cloud.table.mvp.presenter;

import android.app.Activity;
import android.app.Application;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.BillOrderMoney;
import com.gingersoft.gsa.cloud.base.common.bean.OrderBean;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.OpenTableManage;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.contract.BaseOrderContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.request.AddOrderRequest;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.request.CreateOrderRequest;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.OrderContentActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.OrderMoneyAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.SelectMealAdapter;
import com.gingersoft.gsa.cloud.ui.widget.dialog.CommonTipDialog;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.RequestBody;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-11
 * 修订历史：2020-01-11
 * 描述：
 */

@ActivityScope
public class BaseOrderPresenter<M extends BaseOrderContract.Model, V extends BaseOrderContract.View> extends BasePresenter<BaseOrderContract.Model, BaseOrderContract.View> {

    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    protected M mModel;
    protected V mRootView;

    private Activity IActivity;
    private OrderContentActivity mOrderContentActivity;
    private MealStandPresenter mMealStandPresenter;
    private OrderContentPresenter mOrderContentPresenter;
    private OrderPayPresenter mOrderPayPresenter;

    //订单数据管理类
    protected MyOrderManage myOrderManage;

    //訂單食品適配器
    protected SelectMealAdapter mSelectMealAdapter;
    protected List<OrderDetail> mOrderFoodList;

    //整單相關金額適配器
    protected OrderMoneyAdapter mOrderMoneyAdapter;
    protected List<BillOrderMoney> mOrderMoneyList;

    //選中操作的食品下標
    protected int orderSelectPosition = -1;

    //币種
    public String cashStr = "$";

    private final String noFoodDeliveryTip = "賬單沒有食品，是否開台?";

    void saveCreateTime(long createTime) {
        if (OpenTableManage.getDefault().getTableBean() == null) {
            OpenTableManage.getDefault().setTableBean(new TableBean.DataBean());
        }
        OpenTableManage.getDefault().getTableBean().setCreateTime(TimeUtils.getTime(createTime, TimeUtils.DEFAULT_DATE_FORMAT));
    }

    @Inject
    public BaseOrderPresenter(BaseOrderContract.Model model, BaseOrderContract.View rootView) {
        super(model, rootView);
        this.mModel = (M) model;
        this.mRootView = (V) rootView;
        this.IActivity = (Activity) mRootView;
        this.myOrderManage = MyOrderManage.getInstance();
        this.mOrderFoodList = myOrderManage.getOrderFoodList();
        this.mOrderMoneyList = myOrderManage.getOrderMoneyList();

        if (IActivity instanceof OrderContentActivity) {
            mOrderContentActivity = (OrderContentActivity) IActivity;
        }
        if (this instanceof MealStandPresenter) {
            mMealStandPresenter = (MealStandPresenter) this;
        } else if (this instanceof OrderContentPresenter) {
            mOrderContentPresenter = (OrderContentPresenter) this;
        } else if (this instanceof OrderPayPresenter) {
            mOrderPayPresenter = (OrderPayPresenter) this;
        }

        resetSelected();
        initOrderAdapter();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    protected List<Discount> getDiscountList() {
        List<Discount> discountList = new ArrayList<>();

        Discount discount = new Discount();
        discount.setId((long) 1);
        discount.setDiscount_value((double) 10);
        discount.setType(1);
        discount.setStatus(0);
        discount.setRemark("9折");
        discountList.add(discount);

        Discount discount2 = new Discount();
        discount2.setId((long) 2);
        discount2.setDiscount_value((double) 20);
        discount2.setType(1);
        discount2.setStatus(0);
        discount2.setRemark("8折");
        discountList.add(discount2);

        Discount discount3 = new Discount();
        discount3.setId((long) 3);
        discount3.setDiscount_value((double) 30);
        discount3.setType(1);
        discount3.setStatus(0);
        discount3.setRemark("7折");
        discountList.add(discount3);

        Discount discount4 = new Discount();
        discount4.setId((long) 4);
        discount4.setAmount((double) 20);
        discount4.setType(0);
        discount4.setStatus(0);
        discount4.setRemark("立減20");
        discountList.add(discount4);

        return discountList;
    }


    private void initOrderAdapter() {
        if (mSelectMealAdapter == null) {
            mSelectMealAdapter = new SelectMealAdapter(IActivity, mOrderFoodList, this);
            //設置子父級下標
            mSelectMealAdapter.setIndex();
        }
        if (mOrderMoneyAdapter == null) {
            mOrderMoneyAdapter = new OrderMoneyAdapter(IActivity, mOrderMoneyList, cashStr);
        }
        addSentOrderMoney();
        initItemClickListener();
    }

    private void initItemClickListener() {
        mSelectMealAdapter.setOnItemClickListener(new SelectMealAdapter.OnItemClickListener() {

            @Override
            public void onItemClick(OrderDetail datasBean, int position) {
                mRootView.recordOperat(true);
                orderSelectPosition = position;
                mSelectMealAdapter.setMyOrderManageSelectPosition();
            }

            @Override
            public void onMealCountDelete(OrderDetail datasBean, int position) {
                mRootView.recordOperat(true);
                if (datasBean.getNumber() == 1) {
                    mSelectMealAdapter.removeFoodItem();
                } else {
                    changeNumber(datasBean.getNumber() - 1);
                }
                mSelectMealAdapter.notifyDataSetChanged();
                if (mOrderContentActivity != null) {
                    mOrderContentActivity.initOrderDetail();
                }
            }

            @Override
            public void onMealCountAdd(OrderDetail datasBean, int position) {
                mRootView.recordOperat(true);
                changeNumber(datasBean.getNumber() + 1);
                if (mOrderContentActivity != null) {
                    mOrderContentActivity.initOrderDetail();
                }
            }

            @Override
            public void onCurrentOrderDetail(OrderDetail datasBean, int position) {
            }
        });
    }

    public void changeNumber(int number) {
        if (!changeNumberCondition(number)) {
            return;
        }
        myOrderManage.changeNumber(number);
        if (mMealStandPresenter != null) {
            mMealStandPresenter.updateOrderFoodNumber();
        }
        mSelectMealAdapter.notifyDataSetChanged();
    }

    public boolean changeNumberCondition(int i) {
        if (MyOrderManage.getInstance().getSize() <= 0) {
            return false;
        }
        if (mSelectMealAdapter.getSelect_start_position() == -1 || mSelectMealAdapter.getSelect_start_position() >= mSelectMealAdapter.getInfos().size()) {
            return false;
        }
        if (myOrderManage.getOrderFoodList().get(mSelectMealAdapter.getSelect_start_position()).isIsfood() == false) {
            return false;
        }
        //旧食品不可以修改数量
        if (!myOrderManage.isModifyOrder() && myOrderManage.getOrderFoodList().get(mSelectMealAdapter.getSelect_start_position()).isNew() == false && i != 0) {
            return false;
        }
        if (mSelectMealAdapter.getSelect_position() == -1) {
            return false;
        }
        return true;
    }

    /**
     * 送單
     *
     * @param isPrint 是否印單
     */
    public void sendOrder(boolean isPrint) {
        if (MyOrderManage.getInstance().getOrderId() == -1) {
            if (getFoodSize() == 0) {
                Class[] parameterTypes = {boolean.class};
                Object[] parameters = {isPrint};
                CommonTipDialog.showTipAndExecuteMethodDialog(IActivity, noFoodDeliveryTip, BaseOrderPresenter.class, this,
                        "executeCreateOrder", parameterTypes, parameters);
            } else {
                executeCreateOrder(isPrint);
            }
        } else {
            executeAddOrderFood(isPrint);
        }
    }

    private void executeCreateOrder(boolean isPrint) {
        if (mMealStandPresenter != null) {
            mMealStandPresenter.createOrder();
        } else if (mOrderContentPresenter != null) {
            mOrderContentPresenter.createOrder(isPrint);
        } else if (mOrderPayPresenter != null) {
            mOrderPayPresenter.createOrder();
        }
    }

    private void executeAddOrderFood(boolean isPrint) {
        if (mMealStandPresenter != null) {
            mMealStandPresenter.addOrderFood();
        } else if (mOrderContentPresenter != null) {
            mOrderContentPresenter.addOrderFood(isPrint);
        } else if (mOrderPayPresenter != null) {
            mOrderPayPresenter.addOrderFood();
        }
    }

    /**
     * 添加已送單折扣，服務費
     */
    private void addSentOrderMoney() {
        OrderBean orderBean = myOrderManage.getOrderBean();
        if (orderBean != null) {
            //折扣
            Discount discount = new Discount();
            discount.setType(orderBean.getType());
            if (orderBean.getDiscountValue() != 0) {
                //百分比折扣
                discount.setDiscount_value(orderBean.getDiscountValue());
                addOrderDiscount(discount, 1,true);
            }
            if (orderBean.getDiscountAmount() != 0) {
                //金額折扣
                discount.setAmount(orderBean.getDiscountAmount());
                addOrderDiscount(discount, 1,true);
            }
            //TODO 服務費

        }
    }

    /**
     * 添加賬單折扣
     *
     * @param discount
     */
    protected void addOrderDiscount(Discount discount, int status,boolean sentOrder) {
        double totalMoney = getFoodTotal();
        double discountPrice = Discount.calculationDiscount(discount, totalMoney);
        BillOrderMoney orderMoney = new BillOrderMoney();
        orderMoney.setMoney(discountPrice);
//        orderMoney.setTitle(discount.getRemark());
        orderMoney.setTitle("8折");
        orderMoney.setType(BillOrderMoney.DISCOUNT_TYPE);
        if (status == 0) {
            orderMoney.setTextColor(ArmsUtils.getColor(IActivity, R.color.theme_hint_color));
        } else {
            orderMoney.setTextColor(ArmsUtils.getColor(IActivity, R.color.theme_black));
        }
        orderMoney.setStatus(status);
        orderMoney.setDiscount(discount);
        if(sentOrder){
            mOrderMoneyList.clear();
        }
        mOrderMoneyList.add(orderMoney);
        mOrderMoneyAdapter.notifyDataSetChanged();
        //更新總金額
        if (!sentOrder && mOrderContentActivity != null) {
            mOrderContentActivity.initOrderDetail();
        }
    }

    /**
     * 創建訂單后保存OrderId
     *
     * @param orderId
     */
    protected void setOrderId(double orderId) {
        MyOrderManage.getInstance().setOrderId(orderId);
    }

    /**
     * 重置選中狀態
     */
    public void resetSelected() {
        for (int i = 0; i < mOrderFoodList.size(); i++) {
            OrderDetail datasBean = mOrderFoodList.get(i);
            datasBean.setSelected(0);
        }
    }

    /**
     * 獲取食品合計金額
     *
     * @return
     */
    public double getFoodTotal() {
        double total = 0.0;
        for (OrderDetail food : myOrderManage.getOrderFoodList()) {
            total += food.getPrice();
        }
        return MoneyUtil.get_ItemDecimals_money(total);
    }

    /**
     * 獲取總金額:已減去折扣,服務費
     *
     * @return
     */
    public double getTotalAmount() {
        double foodTotal = getFoodTotal();
        for (BillOrderMoney item : mOrderMoneyList) {
            foodTotal += item.getMoney();
            if (0 > foodTotal) {
                //折扣金額不能超出總額
                foodTotal = 0;
            }
        }
        return MoneyUtil.get_ItemDecimals_money(foodTotal);
    }

    /**
     * 獲取食品總數量
     *
     * @return
     */
    public int getFoodCount() {
        int count = 0;
        for (OrderDetail food : myOrderManage.getOrderFoodList()) {
            count += food.getNumber();
        }
        return count;
    }

    /**
     * 獲取食品Item個數
     *
     * @return
     */
    public int getFoodSize() {
        return getOrderFoodLists().size();
    }

    protected String getSelectFoodIds() {
        StringBuilder builder = new StringBuilder();
        List<OrderDetail> orderDetails = getOldOrderFoodLists();
        int start_position = mSelectMealAdapter.getSelect_full_start_position() + 1;
        int end_position = mSelectMealAdapter.getSelect_full_end_position() + 1;
        for (int i = orderDetails.size() - 1; i >= 0; i--) {
            int my_index = orderDetails.get(i).getMyIndex();
            if (start_position <= my_index && my_index <= end_position) {
                OrderDetail orderDetail1 = orderDetails.get(i);
                builder.append(orderDetail1.getId());
                builder.append(",");
            }
        }
        String str = builder.toString();
        if (str.endsWith(",")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    protected CreateOrderRequest getCreateOrderRequest(List<OrderDetail> foodList) {
        int restaurantId = GsaCloudApplication.getRestaurantId(mApplication);
        CreateOrderRequest request = new CreateOrderRequest();
        request.setOrderDetails(orderDetailBeanToFoodRequest(foodList));
        request.setPerson(OpenTableManage.getDefault().getPeopleNumber());
        request.setTableId(OpenTableManage.getDefault().getTableBean().getId());
        request.setTableName(OpenTableManage.getDefault().getTableBean().getTableName());
        request.setRestaurantId(restaurantId);
        Discount orderDiscount = getOrderDiscount();
        if (orderDiscount != null) {
            request.setDetailsId(orderDiscount.getId());
        }
        return request;
    }

    protected AddOrderRequest getAddOrderRequest(List<OrderDetail> foodList) {
        AddOrderRequest request = new AddOrderRequest();
        request.setMaps(orderDetailBeanToAddFoodRequest(foodList));
        request.setOrderId(MyOrderManage.getInstance().getOrderId());
        Discount orderDiscount = getOrderDiscount();
        if (orderDiscount != null) {
            request.setDetailsId(orderDiscount.getId());
        }
        return request;
    }

    protected Map<Long, List<OrderBean.OrderDetailsBean>> orderDetailBeanToFoodRequest(List<OrderDetail> foodList) {
        Map<Long, List<OrderBean.OrderDetailsBean>> orderDetails = new HashMap<>();
        if (foodList != null) {
            //套餐明細ID
            long mapIndex = 0;
            //打印用到，清理掉之前保存的食品
            MyOrderManage.getInstance().getNewFoodList().clear();
            List<OrderBean.OrderDetailsBean> orderItems = null;
            for (int i = 0; i < foodList.size(); i++) {
                OrderDetail food = foodList.get(i);
                if (food.getItemType() == 1) {
                    orderItems = new ArrayList<>();
                    mapIndex += 1;
                }

                OrderBean.OrderDetailsBean request = new OrderBean.OrderDetailsBean();
                request.setMemberId(GsaCloudApplication.getMemberId(mApplication));
                request.setProductName(food.getProductName());
                request.setProductId(food.getProductId());
                request.setParentId(food.getParentId());
                request.setTopId(food.getTopId());
                request.setNumber(food.getNumber());
                request.setPrice(food.getUnit_price());
                request.setType(food.getType());
                request.setAblediscount(food.getAblediscount());
                request.setLunchboxPrice(0);
                if (food.isNew()) {
                    //這裡只添加新食品
                    orderItems.add(request);
                    //保存新食品，打印用到
                    MyOrderManage.getInstance().getNewFoodList().add(food);
                }
                int nextIndex = i + 1;
                if (foodList.size() > nextIndex) {
                    if (foodList.get(nextIndex).getItemType() == 1 && orderItems != null && orderItems.size() > 0) {
                        //下一個食品是不是主食品
                        orderDetails.put(mapIndex, orderItems);
                    }
                } else if (foodList.size() == nextIndex) {
                    //最後
                    if (orderItems != null && orderItems.size() > 0) {
                        orderDetails.put(mapIndex, orderItems);
                    }
                }
            }
        }
        return orderDetails;
    }

    protected Map<String, List<OrderBean.OrderDetailsBean>> orderDetailBeanToAddFoodRequest(List<OrderDetail> foodList) {
        /**
         * 1#主食品（完全新點）
         * 2#主食品+子食品+細項（主食品基礎上新加）
         */
        long type1 = 1;
        long type2 = 2;
        //打印用到，清理掉之前保存的食品
        MyOrderManage.getInstance().getNewFoodList().clear();
        //可重複的map
        Map<String, List<OrderBean.OrderDetailsBean>> orderDetails = new HashMap<>();
        if (foodList != null) {
            //套餐明細ID
            String mapIndex = "1-1";
            int indexCount = 0;
            List<OrderBean.OrderDetailsBean> orderItems = null;
            for (int i = 0; i < foodList.size(); i++) {
                OrderDetail food = foodList.get(i);
                if (food.getItemType() == 1) {
                    orderItems = new ArrayList<>();
                    indexCount += 1;
                    if (food.isNew()) {
                        //完全新點的一個食品
                        mapIndex = indexCount + "-" + type1;
                    } else {
                        //基礎上新加
                        mapIndex = indexCount + "-" + type2;
                    }
                }

                OrderBean.OrderDetailsBean request = new OrderBean.OrderDetailsBean();
                request.setMemberId(GsaCloudApplication.getMemberId(mApplication));
                request.setOrderId(MyOrderManage.getInstance().getOrderId());
                request.setProductName(food.getProductName());
                request.setProductId(food.getProductId());
                request.setParentId(food.getParentId());
                request.setTopId(food.getTopId());
                request.setNumber(food.getNumber());
                request.setPrice(food.getUnit_price());
                request.setType(food.getType());
                request.setAblediscount(food.getAblediscount());
                request.setLunchboxPrice(0);
                if (food.isNew()) {
                    //這裡只添加新食品
                    orderItems.add(request);
                    //保存新食品，打印用到
                    MyOrderManage.getInstance().getNewFoodList().add(food);
                }
                int nextIndex = i + 1;
                if (foodList.size() > nextIndex) {
                    if (foodList.get(nextIndex).getItemType() == 1 && orderItems != null && orderItems.size() > 0) {
                        //下一個食品是不是主食品
                        orderDetails.put(mapIndex, orderItems);
                    }
                } else if (foodList.size() == nextIndex) {
                    //最後
                    if (orderItems != null && orderItems.size() > 0) {
                        orderDetails.put(mapIndex, orderItems);
                    }
                }
            }
        }
        return orderDetails;
    }

    /**
     * 返回未送單食品列表
     *
     * @return
     */
    protected List<OrderDetail> getNewOrderFoodLists() {
        List<OrderDetail> orderDetails = new ArrayList<>();
        for (int i = 0; i < getOrderFoodLists().size(); i++) {
            OrderDetail orderDetail = getOrderFoodLists().get(i);
            if (orderDetail.isNew()) {
                orderDetails.add(orderDetail);
            }
        }
        return orderDetails;
    }

    /**
     * 返回已送單食品列表
     *
     * @return
     */
    protected List<OrderDetail> getOldOrderFoodLists() {
        List<OrderDetail> orderDetails = new ArrayList<>();
        for (int i = 0; i < getOrderFoodLists().size(); i++) {
            OrderDetail orderDetail = getOrderFoodLists().get(i);
            if (!orderDetail.isNew()) {
                orderDetails.add(orderDetail);
            }
        }
        return orderDetails;
    }

    /**
     * 返回整單折扣
     *
     * @return
     */
    private Discount getOrderDiscount() {
        for (BillOrderMoney item : mOrderMoneyList) {
            if (item.getStatus() == 0 && item.getType() == BillOrderMoney.DISCOUNT_TYPE) {
                return item.getDiscount();
            }
        }
        return null;
    }

    protected boolean hasNesOrderFoods() {
        if (getNewOrderFoodLists().size() > 0) {
            return true;
        }
        return false;
    }

    protected boolean hasOldOrderFoods() {
        if (getOldOrderFoodLists().size() > 0) {
            return true;
        }
        return false;
    }

    public List<OrderDetail> getOrderFoodLists() {
        return myOrderManage.getOrderFoodList();
    }

    protected void sortSelectMealByIsNew() {
        List<OrderDetail> orderDetail = mOrderFoodList;
        List<OrderDetail> sortOrderList = new ArrayList<>();
        for (int i = 0; i < orderDetail.size(); i++) {
            sortOrderList.add(orderDetail.get(i));
        }
        Comparator c = new Comparator<OrderDetail>() {
            @Override
            public int compare(OrderDetail o1, OrderDetail o2) {
                Boolean isnew1 = o1.isNew();
                Boolean isnew2 = o2.isNew();
                return isnew1.compareTo(isnew2);
            }
        };
        Collections.sort(sortOrderList, c);
        orderDetail.clear();
        for (int i = 0; i < sortOrderList.size(); i++) {
            orderDetail.add(sortOrderList.get(i));
        }
    }

    protected String getTableName() {
        String tablename = "";
        if (OpenTableManage.getDefault().isSplite()) {
            tablename = OpenTableManage.getDefault().getTableBean().getTableName() + "-" + OpenTableManage.getDefault().getSplitNo();
        } else {
            tablename = OpenTableManage.getDefault().getTableBean().getTableName();
        }
        return tablename;
    }

//    protected String replacer(String str) {
//        String data = str;
//        try {
//            data = data.replaceAll("%(?![0-9a-fA-F]{2})", "%25").replaceAll("\\+", "%2B");
////            data = URLDecoder.decode(data);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        return data;
//    }

    /**
     * 修改訂單
     *
     * @param //orderId 訂單號
     * @param //person  人數
     */
    public void updateOrderPerson(String peopleNumber, TextView textView) {
        RequestBody requestBody = new FormBody.Builder()
                .add("orderId", String.valueOf(MyOrderManage.getInstance().getOrderId()))
                .add("person", String.valueOf(peopleNumber))
                .build();
        mModel.updateOrder(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(null))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult.isSuccess()) {
                            if (mOrderContentActivity != null) {
                                textView.setText(peopleNumber);
                            } else {
                                textView.setText("人數:" + peopleNumber);
                            }
                            OpenTableManage.getDefault().setPeopleNumber(Integer.parseInt(peopleNumber));
                        }
                    }
                });
    }
}

