package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.app.Activity;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.common.bean.BillOrderMoney;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.OrderContentActivity;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class OrderMoneyAdapter extends DefaultAdapter<BillOrderMoney> {

    private Activity mContext;
    private String cashStr;

    private int BillTotalFontSize;

    public OrderMoneyAdapter(Activity context, List<BillOrderMoney> infos, String cashStr) {
        super(infos);
        this.mContext = context;
        this.cashStr = cashStr;
//        this.BillTotalFontSize = GSAApplication.androidSetting.getBillTotalFontSize();
        this.BillTotalFontSize = 18;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<BillOrderMoney> getHolder(View v, int viewType) {
        return new OrderMoneyItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.table_item_order_money;
    }

    class OrderMoneyItemHolder extends BaseHolder<BillOrderMoney> {

        @BindView(R2.id.ll_container)
        LinearLayout ll_container;
        @BindView(R2.id.tv_title)
        TextView tv_title;
        @BindView(R2.id.tv_money)
        TextView tv_money;

        @BindView(R2.id.iv_delete)
        ImageView iv_delete;

        public OrderMoneyItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(BillOrderMoney datasBean, int position) {

            tv_title.setText(datasBean.getTitle());
            tv_money.setText(cashStr + datasBean.getMoney());

            tv_title.setTextSize(BillTotalFontSize);
            tv_money.setTextSize(BillTotalFontSize);

            tv_title.setTextColor(datasBean.getTextColor());
            tv_money.setTextColor(datasBean.getTextColor());

            if (mContext instanceof OrderContentActivity &&
                    datasBean.getType() == BillOrderMoney.DISCOUNT_TYPE &&
                    datasBean.getStatus() == 0) {
                iv_delete.setVisibility(View.VISIBLE);
                iv_delete.setOnClickListener(v -> {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onItemDeleteClick(datasBean, position);
                    }
                });
            } else {
                iv_delete.setVisibility(View.INVISIBLE);
            }
            ll_container.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mOnItemClickListener != null)
                        mOnItemClickListener.onItemClick(datasBean, position);
                }
            });
//            ll_container.setBackgroundColor(datasBean.getBgColor());
        }
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(BillOrderMoney datasBean, int position);

        void onItemDeleteClick(BillOrderMoney datasBean, int position);
    }
}
