package com.gingersoft.supply_chain.mvp.ui.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.listener.OnItemClickListener;
import com.gingersoft.gsa.cloud.common.BuildConfig;
import com.gingersoft.gsa.cloud.common.function.click.SingleClick;
import com.gingersoft.gsa.cloud.common.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerFunctionListComponent;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFunctionBean;
import com.gingersoft.supply_chain.mvp.contract.FunctionListContract;
import com.gingersoft.supply_chain.mvp.presenter.FunctionListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.FunctionChildAdapter;
import com.gingersoft.supply_chain.mvp.ui.adapter.PurchaseFunctionAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.category.CategoryFragment;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.BuyIngredientsFragment;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.FoodIngredientsFragment;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.MeasurementUnitFragment;
import com.gingersoft.supply_chain.mvp.ui.fragment.inventory.StorageListFragment;
import com.gingersoft.supply_chain.mvp.ui.fragment.order.PurchaseListFragment;
import com.gingersoft.supply_chain.mvp.ui.fragment.supplier.SupplierListFragment;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.WareHouseListFragment;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.gingersoft.supply_chain.mvp.ui.fragment.food.FoodIngredientsFragment.FOOD_INGREDIENTS;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/19/2020 16:15
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class FunctionListFragment extends BaseSupplyChainFragment<FunctionListPresenter> implements FunctionListContract.View {

    @BindView(R2.id.topbar_supply_chain)
    QMUITopBar mTopBar;
    @BindView(R2.id.rv_supply_chain_function_list)
    RecyclerView rvSupplyChainFunctionList;

    public static FunctionListFragment newInstance() {
        FunctionListFragment fragment = new FunctionListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerFunctionListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_function_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTopBar();
        List<PurchaseFunctionBean> purchaseFunctionBeans = new ArrayList<>();

        List<Function> basicManagementFunction = new ArrayList<>();
        basicManagementFunction.add(new Function("供應商", R.drawable.ic_supplier));
        basicManagementFunction.add(new Function("食材", R.drawable.ic_food_ingredients));
        basicManagementFunction.add(new Function("種類", R.drawable.ic_type));
//        basicManagementFunction.add(new Function("包裝", R.drawable.ic_packing));
        purchaseFunctionBeans.add(new PurchaseFunctionBean("基礎管理", basicManagementFunction));

        List<Function> orderManger = new ArrayList<>();
        orderManger.add(new Function("採購訂單", R.drawable.ic_purchase_order));
        purchaseFunctionBeans.add(new PurchaseFunctionBean("訂單管理", orderManger));

        List<Function> storage = new ArrayList<>();
        storage.add(new Function("庫存查詢", R.drawable.ic_purchase_order));
        if (BuildConfig.DEBUG) {
            storage.add(new Function("切換環境", R.drawable.ic_seekbar_btn));
        }
        purchaseFunctionBeans.add(new PurchaseFunctionBean("庫存管理", storage));

        PurchaseFunctionAdapter purchaseFunctionAdapter = new PurchaseFunctionAdapter(mContext, purchaseFunctionBeans);
        purchaseFunctionAdapter.setFunctionClickListener((adapter, view, position) -> {
            FunctionChildAdapter functionChildAdapter = (FunctionChildAdapter) adapter;
            List<Function> data = functionChildAdapter.getData();
            switch (data.get(position).getResName()) {
                case "供應商":
                    start(SupplierListFragment.newInstance(false, null));
                    break;
                case "食材":
//                    start(FoodIngredientsFragment.newInstance(FOOD_INGREDIENTS));
                    start(BuyIngredientsFragment.newInstance(FOOD_INGREDIENTS));
                    break;
                case "種類":
                    start(CategoryFragment.newInstance());
                    break;
                case "包裝":
                    start(MeasurementUnitFragment.newInstance(false));
                    break;
                case "採購訂單":
                    start(PurchaseListFragment.newInstance());
                    break;
                case "入庫":
                    start(StorageListFragment.newInstance());
                    break;
                case "庫存查詢":
                    start(WareHouseListFragment.newInstance());
                    break;
                case "切換環境":
                    int format = (int) SPUtils.get("isFormal", 3);
                    if (format == 3) {
                        showMessage("已切換到測試環境，重啟生效");
                        SPUtils.put("isFormal", 1);
                    } else {
                        showMessage("已切換到本地環境，重啟生效");
                        SPUtils.put("isFormal", 3);
                    }
                    break;
                default:

                    break;
            }
        });
        rvSupplyChainFunctionList.setAdapter(purchaseFunctionAdapter);
    }

    private void initTopBar() {
        mTopBar.setTitle("採購");
        mTopBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
    }

}
