package com.gingersoft.gsa.cloud.bean.mvp.contract;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.FoodBean;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;

import androidx.recyclerview.widget.RecyclerView;
import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/22/2020 10:39
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface SoldoutCtrlContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {

        void setCurrentSoldoutFoodAdapter(DefaultAdapter adapter);

        void setFoodGroupAdapter(DefaultAdapter adapter);

        void setFoodAdapter(DefaultAdapter adapter);

        void setComboAdapter(DefaultAdapter adapter);

        RecyclerView getRecycleCurrentSoldoutFood();

        RecyclerView getRecycleFoodGroup();

        RecyclerView getRecycleFood();

        void setFoodGroupRecycleSpanCount(int size);

        void setFoodRecycleSpanCount(int size);

        int getSoldoutType();

        boolean isInitFineItemLayout();

        void initFineItemTabBarViewPage();

        void showFoodLayoutVisibility();

        void showFineItemLayoutVisibility();

        void showTvRestore(boolean show);

        void showViewModeVisibility(int... viewMode);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {

        List<Food> queryDB_AllFoodList();

        List<Food> queryDB_FoodGroupList();

        List<Food> queryDB_FoodList(long parentId);

        List<Food> queryDB_FoodListByIds(String [] ids);

        Observable<BaseResult> getCurrentSoldoutFood(RequestBody requestBody);

        Observable<BaseResult> insertSoldoutCtrl(RequestBody requestBody, int operatTtpe, int type);

        Observable<BaseResult> restoreSoldoutCtrl( RequestBody requestBody);

        Observable<BaseResult> batchRestoreSoldoutCtrl( RequestBody requestBody);

        Observable<BaseResult> updateInvisible( RequestBody requestBody);

        Observable<FoodBean> downFoodList(int restaurantId);

        Observable<BaseResult> downFoodModifier(int restaurantId);
    }
}
