package com.gingersoft.gsa.cloud.bean.mvp.presenter;

import android.app.Application;
import android.content.Context;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.view.View;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.order.bean.OrderBean;
import com.gingersoft.gsa.cloud.base.order.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.bean.mealManger.MyOrderManage;
import com.gingersoft.gsa.cloud.base.order.bean.mealManger.OpenTableManage;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.base.table.bean.TableExtBean;
import com.gingersoft.gsa.cloud.base.utils.JsonUtils;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.bean.ComponentTable;
import com.gingersoft.gsa.cloud.bean.R;
import com.gingersoft.gsa.cloud.bean.mvp.contract.TableContract;
import com.gingersoft.gsa.cloud.bean.mvp.model.bean.BaseOrderRespose;
import com.gingersoft.gsa.cloud.bean.mvp.model.bean.TableDetail;
import com.gingersoft.gsa.cloud.bean.mvp.model.table.action.MoveTableAction;
import com.gingersoft.gsa.cloud.bean.mvp.model.table.action.PrintServingPaperAction;
import com.gingersoft.gsa.cloud.bean.mvp.model.table.action.PrintSkyOrderAction;
import com.gingersoft.gsa.cloud.bean.mvp.model.table.action.ResetTableAction;
import com.gingersoft.gsa.cloud.bean.mvp.model.table.action.SplitTableAction;
import com.gingersoft.gsa.cloud.bean.mvp.model.table.action.TableAction;
import com.gingersoft.gsa.cloud.bean.mvp.model.utils.OrderAssemblyUtil;
import com.gingersoft.gsa.cloud.bean.mvp.ui.activity.TableActivity;
import com.gingersoft.gsa.cloud.bean.mvp.ui.adapter.BottomFunctionAdapter;
import com.gingersoft.gsa.cloud.bean.mvp.ui.widget.SplitTableDialog;
import com.gingersoft.gsa.cloud.constans.GoldConstants;
import com.gingersoft.gsa.cloud.constans.PrintConstans;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.FoodComboDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.function.FunctionManager;
import com.gingersoft.gsa.cloud.ui.widget.dialog.BaseRetryDialog;
import com.gingersoft.gsa.cloud.ui.widget.dialog.CommonTipDialog;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;
import com.scwang.smartrefresh.layout.api.RefreshLayout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.RequestBody;

import static com.gingersoft.gsa.cloud.base.order.bean.OrderDetail.FOOD_TYPE;
import static com.gingersoft.gsa.cloud.base.order.bean.OrderDetail.MODIFIER_TYPE;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:19
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class TablePresenter extends BasePresenter<TableContract.Model, TableContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private TableActivity IActivity;

    /**
     * 分檯弹窗
     */
    private SplitTableDialog mSplitTableDialog;

    private List<TableBean.DataBean> mTableList = new ArrayList<>();

    private BottomFunctionAdapter mBottomFunctionAdapter;
    private List<Function> mBottomFunctionList = new ArrayList<>();

    private TableAction mTableAction;
    private List<TableAction> mTableActions = new ArrayList<>();
    /**
     * 选中操作的台名、id、分檯編號
     */
    private String originalTableName = "";
    private long originalTableId;
    private String originalTableNumber = "";
    /**
     * 转台需要转到台名、id、分檯編號
     */
    private String targetTableName = "";
    private long targetTableId;
    private String targetTableNumber = "";

    private GetTableTimer tableTimer;
    private Disposable mGetTablesDataDisposable;

    @Inject
    public TablePresenter(TableContract.Model model, TableContract.View rootView) {
        super(model, rootView);
        this.IActivity = (TableActivity) rootView;

        initGetTableTimer();
    }

    private void initTableActions(Context context, List<Function> functions) {
        for (Function function : functions) {
            if (function.getResUrl().endsWith("init")) {
                mTableActions.add(new ResetTableAction(context));
            } else if (function.getResUrl().endsWith("move")) {
                mTableActions.add(new MoveTableAction(context));
            } else if (function.getResUrl().endsWith("splite")) {
                mTableActions.add(new SplitTableAction(context));
            } else if (function.getResUrl().endsWith("parper")) {
                mTableActions.add(new PrintServingPaperAction(context));
            } else if (function.getResUrl().endsWith("skyorder")) {
                mTableActions.add(new PrintSkyOrderAction(context));
            }
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;

        cancelTableTimer();
    }

    public void initBottomFunction() {
        if (mBottomFunctionAdapter == null) {
            mBottomFunctionAdapter = new BottomFunctionAdapter(IActivity, mBottomFunctionList);
            mRootView.setBottomFunctionAdapter(mBottomFunctionAdapter);
        }
        initBottomFunctionItem();
        initBottomFunctionListener();
    }

    private void initBottomFunctionListener() {
        mBottomFunctionAdapter.setOnItemClickListener(new DefaultAdapter.OnRecyclerViewItemClickListener() {

            @Override
            public void onItemClick(View view, int viewType, Object data, int position) {
//                Function function = (Function) data;
//                switch (function.getStatus()) {
//                    case STATUS_NONACTIVATED:
//                        mRootView.showMessage("服務暫未開通,敬請期待");
//                        return;
//                    case STATUS_TIME_LIMIT:
//                        mRootView.showMessage("服務已到期,請前往續費");
//                        return;
//                }
                if (mTableActions.size() > position) {
                    mTableAction = mTableActions.get(position);
                    if (mTableAction != null) {
                        boolean isMoveTableAction = mTableAction instanceof MoveTableAction;
                        if (!isMoveTableAction) {
                            filterTableByAction();
                        }
                        mRootView.setCurrentTableAction(mTableAction);
                    }
                }
            }
        });
    }

    public void initBottomFunctionItem() {
        if (mBottomFunctionList.size() > 0) {
            mBottomFunctionList.clear();
        }
        boolean addFuctions = false;
        List<Function> functions = FunctionManager.getDefault().getFunctionByResModule(GsaCloudApplication.getAppContext(), ComponentTable.table.class, ComponentTable.table.bottom, "bottom");
        for (int i = 0; i < functions.size(); i++) {
            Function function = functions.get(i);
            if (function.getParentId() == 0) {
                //有配置餐檯操作模块
                functions.remove(i);
                addFuctions = true;
            }
        }
        if (addFuctions) {
            mBottomFunctionList.addAll(functions);
            mRootView.setBottomFunctionVisibility(true);
            mBottomFunctionAdapter.notifyDataSetChanged();
        } else {
            mRootView.setBottomFunctionVisibility(false);
        }
        initTableActions(IActivity, functions);
//        mBottomFunctionList.add(new Function((long) 1, "重置檯號", ArmsUtils.getColor(IActivity, R.color.theme_black), ArmsUtils.getDimens(IActivity, R.dimen.sp_14), R.mipmap.table_init));
//        mBottomFunctionList.add(new Function((long) 2, "轉檯", ArmsUtils.getColor(IActivity, R.color.theme_black), ArmsUtils.getDimens(IActivity, R.dimen.sp_14), R.mipmap.table_move));
//        mBottomFunctionList.add(new Function((long) 3, "分檯", ArmsUtils.getColor(IActivity, R.color.theme_black), ArmsUtils.getDimens(IActivity, R.dimen.sp_14), R.mipmap.table_splite));
//        mBottomFunctionList.add(new Function((long) 4, "skyorder", ArmsUtils.getColor(IActivity, R.color.theme_black), ArmsUtils.getDimens(IActivity, R.dimen.sp_14), R.mipmap.table_skyorder));
//        mBottomFunctionList.add(new Function((long) 5, "上菜紙", ArmsUtils.getColor(IActivity, R.color.theme_black), ArmsUtils.getDimens(IActivity, R.dimen.sp_14), R.mipmap.table_paper));
    }


    public void getTables(boolean show, RefreshLayout refreshLayout) {
        int restaurantId = GsaCloudApplication.getRestaurantId();
        mModel.getTables(restaurantId)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> {
                    if (show && refreshLayout == null) {
                        mRootView.showLoading(null);
                    }
                })
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> {
                    if (show && refreshLayout == null) {
                        mRootView.hideLoading();
                    }
                })
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<TableBean>(mErrorHandler) {

                    @Override
                    public void onSubscribe(Disposable d) {
                        super.onSubscribe(d);
                        mGetTablesDataDisposable = d;
                    }

                    @Override
                    public void onNext(@NonNull TableBean tableBean) {
                        if (!TableActivity.isRefreshData) {
                            return;
                        }
                        if (tableBean.isSuccess()) {
                            List<TableBean.DataBean> tableBeanData = tableBean.getData();
                            if (tableBeanData != null && tableBeanData.size() > 0) {
                                if (mTableList.size() > 0) {
                                    mTableList.clear();
                                }
                                sortTableList(tableBeanData);
                                mTableList.addAll(tableBeanData);
                                mRootView.returnTableList(tableBeanData);
                            } else {
                                mRootView.getCurrentTableFragment().showEmptyView(true, 0, null);
                            }
                        } else {
                            if (show) {
                                mRootView.getCurrentTableFragment().showMessage(tableBean.getErrMsg());
                            }
                            mRootView.getCurrentTableFragment().showEmptyView(false, 0, null);
                        }
                        resetRefreshLayout();
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        if (mRootView.getCurrentTableFragment() != null) {
                            mRootView.getCurrentTableFragment().showEmptyView(false, 0, t);
                        }
                        resetRefreshLayout();
                    }

                    private void resetRefreshLayout() {
                        if (refreshLayout != null) {
                            refreshLayout.finishRefresh();
                            refreshLayout.resetNoMoreData();
                        }
                    }

                    private void sortTableList(List<TableBean.DataBean> dataBeanList) {
                        Comparator c = new Comparator<TableBean.DataBean>() {
                            @Override
                            public int compare(TableBean.DataBean o1, TableBean.DataBean o2) {
                                Integer sort1 = o1.getSort();
                                Integer sort2 = o2.getSort();
                                return sort1.compareTo(sort2);
                            }
                        };
                        Collections.sort(dataBeanList, c);
                    }
                });
    }

    public void loadOrderToPrintParper(TableBean.DataBean tableBean) {
        if (tableBean.getOrderId() == null) {
            return;
        }
        mModel.getOrderById(tableBean.getOrderId())
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(null))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseOrderRespose>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull BaseOrderRespose respose) {
                        if (respose.isSuccess()) {
                            OpenTableManage.getDefault().setPeopleNumber(0);
                            //設置當前開台數據1584427984728 1584428017196 1584428086282
//                            TableBean.DataBean dataBean = getTableById(tableId);
                            TableBean.DataBean openTableBean = tableBean;
//                            if (dataBean != null) {
//                                openTableBean = new TableBean.DataBean(dataBean);
//                            }
                            OrderBean orderBean = respose.getData();
                            if (orderBean != null && respose.getData().getOrderDetails() != null) {
                                if (respose.getData().getCreateTime() != null && openTableBean != null) {
                                    //將開台時間設置為訂單創建時間
                                    openTableBean.setCreateTime(TimeUtils.getFormatTime(respose.getData().getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT));
                                }
                                OpenTableManage.getDefault().setPeopleNumber(orderBean.getPerson());

                                List<OrderBean.OrderDetailsBean> orderDetailsBeans = respose.getData().getOrderDetails();

                                //緩存訂單信息
                                MyOrderManage.getInstance().setOrderBean(new OrderBean(orderBean));
                                //緩存食品信息
                                List<OrderDetail> orderDetailList = OrderAssemblyUtil.assemblyOrder(OrderDetail.orderTransOrderDetails(orderDetailsBeans));

                                MyOrderManage.getInstance().setOrderFoodList(orderDetailList);
                            } else {
                                MyOrderManage.getInstance().setOrderBean(null);
                                MyOrderManage.getInstance().setOrderFoodList(new ArrayList<>());
                            }
                            OpenTableManage.getDefault().setTableBean(openTableBean);

                            printParper();
                        } else {
                            CommonTipDialog.showSurpisedDialog(IActivity, respose.getErrMsg(), null, null, null, null, null);
                        }
                    }

                    /**
                     * 打印上菜紙
                     */
                    private void printParper() {
                        CC.obtainBuilder("Component.Print")
                                .setActionName("printActivity")
                                .addParam(PrintConstans.PRINT_TYPE, PrintConstans.PRINT_SERVE)
                                .build()
                                .callAsyncCallbackOnMainThread((cc, result) -> {
                                    //清空賬單數據
                                    MyOrderManage.getInstance().clear();
                                    //清空開檯數據
                                    OpenTableManage.getDefault().clear();

                                    mRootView.canceTableAction();
                                });
                    }
                });
    }

    public void openTable(long tableId, TableBean.DataBean tableExtBean) {
        String tableNumber = "";
        if (tableExtBean != null) {
            tableNumber = tableExtBean.getTableNumber();
        }
        RequestBody requestBody = new FormBody.Builder()
                .add("id", String.valueOf(tableId))
                .add("tableNumber", tableNumber)
                .build();
        mModel.openTable(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(null))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseOrderRespose>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull BaseOrderRespose respose) {
                        if (respose.isSuccess()) {
                            //設置當前開台數據
                            TableBean.DataBean openTableBean;
                            if (tableExtBean != null) {
                                openTableBean = tableExtBean;
                                if (mSplitTableDialog != null) {
                                    mSplitTableDialog.closeDialog();
                                }
                            } else {
                                openTableBean = getTableById(tableId);
                            }
                            OpenTableManage.getDefault().setPeopleNumber(0);
                            OpenTableManage.getDefault().setPeopleNumber(openTableBean.getSeatCount());

                            OrderBean orderBean = respose.getData();
                            if (orderBean != null && respose.getData().getOrderDetails() != null) {
                                if (respose.getData().getCreateTime() != null && openTableBean != null) {
                                    //將開台時間設置為訂單創建時間
                                    openTableBean.setCreateTime(TimeUtils.getFormatTime(respose.getData().getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT));
                                }
                                OpenTableManage.getDefault().setPeopleNumber(orderBean.getPerson());

                                List<OrderBean.OrderDetailsBean> orderDetailsBeans = orderBean.getOrderDetails();

                                setFoodPoints(orderDetailsBeans);
                                //設置套餐topId
                                setTopId(orderDetailsBeans);
                                //緩存訂單信息
                                MyOrderManage.getInstance().setOrderBean(new OrderBean(orderBean));
                                //緩存食品信息
                                List<OrderDetail> orderDetailList = OrderAssemblyUtil.assemblyOrder(OrderDetail.orderTransOrderDetails(orderDetailsBeans));
                                MyOrderManage.getInstance().setOrderFoodList(orderDetailList);

                                if (orderBean.getMemberInfo() != null) {
                                    //设置会员信息
                                    MyOrderManage.getInstance().setMemberInfo(orderBean.getMemberInfo());
                                    MyOrderManage.getInstance().setMemberUpdateStatus(true + "-" + true);
                                }else {
                                    MyOrderManage.getInstance().setMemberUpdateStatus(false + "-" + false);
                                }
                            } else {
                                MyOrderManage.getInstance().setOrderBean(null);
                                MyOrderManage.getInstance().setOrderFoodList(new ArrayList<>());
                            }
                            OpenTableManage.getDefault().setTableBean(openTableBean);
                            mRootView.startMealStandActivity();
                        } else {
                            CommonTipDialog.showSurpisedDialog(IActivity, respose.getErrMsg(), null, null, null, null, null);
                        }
                    }
                });
    }

    /**
     * 設置已送單食品積分(訂單表沒有存儲食品積分字段)
     */
    private void setFoodPoints(List<OrderBean.OrderDetailsBean> orderDetailsBeans) {
        List<Food> foods = mModel.queryDB_AllFoodList();
        for (int i = 0; i < orderDetailsBeans.size(); i++) {
            OrderBean.OrderDetailsBean orderDetailsBean = orderDetailsBeans.get(i);
            if (orderDetailsBean.getType() != FOOD_TYPE) {
                continue;
            }
            for (int j = 0; j < foods.size(); j++) {
                Food food = foods.get(j);
                if (food.getId() == orderDetailsBean.getProductId()) {
                    orderDetailsBean.setPointsAdd(food.getPointsAdd());
                    orderDetailsBean.setPointsRedeem(food.getPointsRedeem());
                }
            }
        }
    }

    /**
     * 設置套餐，細項組別ID
     *
     * @param orderDetailsBeans
     */
    private void setTopId(List<OrderBean.OrderDetailsBean> orderDetailsBeans) {
        long paroductId = 0;
        long topId = 0;
        for (int i = 0; i < orderDetailsBeans.size(); i++) {
            OrderBean.OrderDetailsBean orderDetailsBean = orderDetailsBeans.get(i);
            if (orderDetailsBean.getType() == FOOD_TYPE) {
                int nextIndex = i + 1;
                if (orderDetailsBean.getParentId() == 0 || (orderDetailsBeans.size() > nextIndex && orderDetailsBeans.get(nextIndex).getType() == MODIFIER_TYPE)) {
                    paroductId = orderDetailsBean.getProductId();
                }
                topId = getComboIdByFid(paroductId);
            } else {
                topId = 0;
                List<Modifier> modifierList = mModel.queryDB_ModifierList(paroductId, ModifierDaoUtils.modifierMode_All);
                for (Modifier modifier : modifierList) {
                    if (modifier.getMid() == orderDetailsBean.getProductId()) {
                        topId = modifier.getTopId();
                        break;
                    }
                }
//                topId = CommonConfiguration.getInstance().getModifierTopIdMid((int) orderDetailsBean.getProductId());
            }
            if (orderDetailsBean.getParentId() != 0) {
                orderDetailsBean.setTopId(topId);
            }
        }
    }

    private long getComboIdByFid(long fid) {
        FoodComboDaoUtils daoUtils = new FoodComboDaoUtils(GsaCloudApplication.getAppContext());
        List<FoodCombo> foodCombos = daoUtils.queryCombosByQueryBuilder(fid);
        if (foodCombos != null && foodCombos.size() > 0) {
            return foodCombos.get(0).getComId();
        }
        return 0;
    }

    public void getTableToMove(TableBean.DataBean dataBean) {
        mModel.getTable(dataBean.getId(), dataBean.getTableNumber())
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(null))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<TableDetail>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull TableDetail result) {
                        if (result.isSuccess()) {
                            TableBean.DataBean tableBean = result.getData();
                            if (tableBean != null) {
                                if (!TextUtils.isEmpty(tableBean.getTableNumber())) {
                                    //如果是分檯拼接分檯名称
                                    tableBean.setTableName(tableBean.getTableName() + "-" + tableBean.getTableNumber());
                                }
                                if (originalTableId == 0) {
                                    if (tableBean.getUseStatus() == 1) {
                                        mRootView.showMessage("此檯使用中.");
                                        return;
                                    }
                                    if (tableBean.getStatus() == 0) {
                                        mRootView.showMessage("此檯未開檯.");
                                        return;
                                    }
                                    originalTableName = tableBean.getTableName();
                                    originalTableId = tableBean.getId();
                                    originalTableNumber = tableBean.getTableNumber();
                                    mRootView.setTableActionContentText("由: " + originalTableName + " 轉到 ");
                                } else {
                                    if (tableBean.getUseStatus() == 1) {
                                        mRootView.showMessage("此檯使用中.");
                                        return;
                                    }
                                    targetTableName = tableBean.getTableName();
                                    targetTableId = tableBean.getId();
                                    targetTableNumber = tableBean.getTableNumber();
                                    if (tableBean.getStatus() == 1 || tableBean.getStatus() == 2 || tableBean.getStatus() == 3) {
                                        mRootView.setTableActionContentText("由: " + originalTableName + " 合併 " + targetTableName);
                                    } else {
                                        mRootView.setTableActionContentText("由: " + originalTableName + " 轉到 " + targetTableName);
                                    }
                                    showMoveActionDialog(tableBean);
                                }
                            }
                        } else {
                            mRootView.showMessage(result.getErrMsg());
                        }
                    }
                });
    }

    public void turnTable(long originalTableId, long targetTableId, String tableNumber, String targetTableNumber, boolean isMergeTable) {

        RequestBody requestBody = new FormBody.Builder()
                .add("id", String.valueOf(originalTableId))
                .add("tableId", String.valueOf(targetTableId))
                .add("tableNumber", tableNumber)
                .add("targetTableNumber", targetTableNumber)
                .build();

        mModel.turnTable(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(null))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseOrderRespose>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull BaseOrderRespose respose) {
                        if (respose.isSuccess()) {
                            if (isMergeTable) {
                                mRootView.showMessage("合併成功");
                            } else {
                                mRootView.showMessage("轉檯成功");
                            }
                            mRootView.canceTableAction();
                            //立即獲取餐檯數據
                            getTables(false, null);
                        } else {
                            mRootView.showMessage(respose.getErrMsg());
                        }
                    }
                });
    }

    public void initTable(int tableId, String tableNumber, boolean showMessage) {

        RequestBody requestBody = new FormBody.Builder()
                .add("id", tableId + "")
                .add("tableNumber", tableNumber)
                .build();

        mModel.initTable(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> {
                    if (showMessage) {
                        mRootView.showLoading(null);
                    }
                })
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> {
                    if (showMessage) {
                        mRootView.hideLoading();
                    }
                })
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseOrderRespose>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull BaseOrderRespose respose) {

                        if (respose.isSuccess()) {

//                            if (showMessage)
//                                mRootView.showMessage("重置成功!");

                            mRootView.canceTableAction();

                            getTables(false, null);

                            refreshSplitTablesDialog();
                        } else {
                            if (showMessage) {
                                mRootView.showMessage(respose.getErrMsg());
                            }
                        }
                    }
                });
    }

    public void getSplitTables(int tableId) {
        mModel.getSplitTables(tableId)
                .subscribeOn(Schedulers.io())
//                .doOnSubscribe(disposable -> mRootView.showLoading(null))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
//                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {

                    @Override
                    public void onSubscribe(Disposable d) {
                        super.onSubscribe(d);
                        mSplitTableDialog.clearItems();
                        mSplitTableDialog.setProgressVisibility(true);
                    }

                    @Override
                    public void onNext(@NonNull BaseResult info) {
                        if (info != null && info.isSuccess()) {
                            if (info.getData() != null) {

                                TableExtBean tableExtBean = JsonUtils.parseObject(info.getData(), TableExtBean.class);

                                List<TableBean.DataBean> dataBeanList = assemblyTableExts(tableExtBean.getRestaurantTable(), tableExtBean.getRestaurantTableExtList());

                                mSplitTableDialog.addItems(dataBeanList);
                                mSplitTableDialog.notifyDataSetChanged();
                            } else {
                                mSplitTableDialog.showEmptyView(true, 0, null);
                            }
                        } else {
                            mSplitTableDialog.showEmptyView(false, 0, null);
                        }
                        mSplitTableDialog.setProgressVisibility(false);
                    }

                    @Override
                    public void onError(Throwable t) {
                        super.onError(t);
                        mSplitTableDialog.setProgressVisibility(false);
                        mSplitTableDialog.showEmptyView(false, 0, t);
                    }

                    private List<TableBean.DataBean> assemblyTableExts(TableBean.DataBean mainTable, List<TableExtBean.DataBean> restaurantTableExtList) {
                        List<TableBean.DataBean> dataBeans = new ArrayList<>();
                        //添加主檯
                        dataBeans.add(mainTable);
                        //添加分檯
                        for (TableExtBean.DataBean dataBean : restaurantTableExtList) {
                            dataBeans.add(TableBean.splitTableTransformTable2(mainTable, dataBean));
                        }
                        return dataBeans;
                    }
                });
    }

    public void splitTable(TableBean.DataBean tableBean) {
        mModel.splitTable(tableBean.getId())
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(null))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull BaseResult result) {
                        if (result.isSuccess()) {
                            if (result.getData() != null) {
                                TableExtBean.DataBean tableExtBean = JsonUtils.parseObject(result.getData(), TableExtBean.DataBean.class);
                                long tableExtId = tableExtBean.getId();
                                //分檯开檯
                                openTable(tableExtId, TableBean.splitTableTransformTable(tableBean, tableExtBean));
                            }
                        } else {
                            mRootView.showMessage(result.getErrMsg());
                        }
                    }
                });
    }

    /**
     * 刷新分檯数据
     */
    private void refreshSplitTablesDialog() {
        if (mSplitTableDialog != null) {
            //刷新餐檯
            getSplitTables(mSplitTableDialog.getMainTableId());
        }
    }

    /**
     * 根据操作类型过滤一遍餐台
     */
    public void filterTableByAction() {
        if (mTableList.size() == 0) {
            return;
        }
        List<TableBean.DataBean> filterTableBeanList = new ArrayList<>();
        if (mTableAction != null) {
            for (int i = 0; i < mTableList.size(); i++) {
                TableBean.DataBean dataBean = mTableList.get(i);
                if (mTableAction.filterTableCondition(dataBean)) {
                    filterTableBeanList.add(dataBean);
                }
            }
        } else {
            //正常餐檯模式下顯示所有餐檯數據
            filterTableBeanList.addAll(mTableList);
        }
        IActivity.nofilyFragmentUpdateTableData(filterTableBeanList);
    }

    public void showMoveActionDialog(TableBean.DataBean dataBean) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(IActivity);
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        //是否合併檯
        boolean isMergeTable = false;
        String message;
        if (dataBean.getStatus() == 1 || dataBean.getStatus() == 2 || dataBean.getStatus() == 3) {
            message = "是否由%s號檯合併到%s號檯";
            isMergeTable = true;
        } else {
            message = "是否由%s號檯轉到%s號檯";
        }
        dialogBuilder.setMessage(String.format(message, originalTableName, targetTableName));
        boolean finalIsMergeTable = isMergeTable;
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, new QMUIDialogAction.ActionListener() {
            @Override
            public void onClick(QMUIDialog dialog, int index) {
                dialog.dismiss();
                turnTable(originalTableId, targetTableId, originalTableNumber, targetTableNumber, finalIsMergeTable);
            }
        });
        dialogBuilder.addAction("取消", new QMUIDialogAction.ActionListener() {
            @Override
            public void onClick(QMUIDialog dialog, int index) {
                dialog.dismiss();
                mTableAction.cancel();
            }
        });
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

    public void showSplitTableDialog(int tableId) {
        if (mSplitTableDialog == null) {
            mSplitTableDialog = new SplitTableDialog(IActivity);
            mSplitTableDialog.setOnClickListener(new SplitTableDialog.OnClickListener() {
                @Override
                public void onItemClick(SplitTableDialog dialog, TableBean.DataBean dataBean, int position) {
                    if (mTableAction != null) {
                        if (mTableAction instanceof MoveTableAction) {
                            getTableToMove(dataBean);
                        } else {
                            mTableAction.action(dataBean);
                        }
                    } else {
                        //開台操作
                        openTable(dataBean.getId(), dataBean);
                    }
                    mSplitTableDialog.closeDialog();
                }
            });
            mSplitTableDialog.setOnRetryListener(new BaseRetryDialog.OnRetryListener() {
                @Override
                public void onRetryClick() {
                    getSplitTables(tableId);
                }
            });
        }
        mSplitTableDialog.setMainTableId(tableId);
        mSplitTableDialog.build().show();
        getSplitTables(tableId);
    }

    /**
     * 執行餐檯操作
     */
    public boolean doTableAction(TableBean.DataBean dataBean) {
        if (mTableAction != null) {
            mTableAction.action(dataBean);
            mTableAction.setActionListener(new TableAction.OnActionListener() {

                @Override
                public void setOperatContentText(String content) {
                    mRootView.setTableActionContentText(content);
                }

                @Override
                public void resetTable(TableBean.DataBean tableBean) {
                    initTable(tableBean.getId(), tableBean.getTableNumber(), true);
                }

                @Override
                public void moveTable(TableBean.DataBean tableBean) {
//                    if (dataBean.getId() == tableBean.getId()) {
//                        CommonTipDialog.showSurpisedDialog(IActivity, "相同檯不能轉移", null, null, null, null, null);
//                        return;
//                    }
                    getTableToMove(tableBean);
                }

                @Override
                public void loadOrderToPrint(TableBean.DataBean tableBean) {
                    loadOrderToPrintParper(tableBean);
                }

                @Override
                public void splitTableAction(TableBean.DataBean tableBean) {
                    splitTable(tableBean);
                }

                @Override
                public void showSplitTableDialogAction() {
                    showSplitTableDialog(dataBean.getId());
                }

                @Override
                public void cancel() {
                    initTableActionParameter();
                    mRootView.canceTableAction();
                }
            });
            return true;
        }
        return false;
    }

    /**
     * 初始化操作參數
     */
    public void initTableActionParameter() {
        originalTableName = "";
        originalTableId = 0;
        originalTableNumber = "";
        targetTableName = "";
        targetTableId = 0;
        targetTableNumber = "";
        mTableAction = null;
    }

    private TableBean.DataBean getTableById(long id) {
        for (int i = 0; i < mTableList.size(); i++) {
            TableBean.DataBean dataBean = mTableList.get(i);
            if (dataBean.getId() == id) {
                return dataBean;
            }
        }
        return null;
    }


    public void initGetTableTimer() {
        if (tableTimer == null) {
            tableTimer = new GetTableTimer(GoldConstants.refreshTime * 1000, GoldConstants.refreshTime * 1000);
        }
        TableActivity.isRefreshData = true;
        tableTimer.start();
    }

    public void startTableTimer() {
        if (tableTimer != null) {
            tableTimer.start();
        }
    }

    public void cancelTableTimer() {
        if (tableTimer != null) {
            tableTimer.cancel();
        }
    }

    /**
     * 计时器类 定時更新餐台数据
     */
    private class GetTableTimer extends CountDownTimer {

        public GetTableTimer(long millisInFuture, long countDownInterval) {
            super(millisInFuture, countDownInterval);// 参数依次为总时长,和计时的时间间隔
        }

        @Override
        public void onFinish() {// 计时完毕时触发
            if (TableActivity.isRefreshData) {
                getTables(false, null);
            }
            this.start();
        }

        @Override
        public void onTick(long millisUntilFinished) {// 计时过程显示
        }
    }

    public Disposable getGetTablesDataDisposable() {
        return mGetTablesDataDisposable;
    }

    public List<TableBean.DataBean> getTableList() {
        return mTableList;
    }
}
