package com.gingersoft.gsa.cloud.base.common.bean;

import android.graphics.Color;
import android.text.TextUtils;

import com.google.gson.annotations.SerializedName;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-15
 * 修订历史：2020-02-15
 * 描述：
 */
@Data
public class PayMethod {

    /**
     * id : 12
     * brandId : 1
     * restaurantId : 26
     * nameFirst : 兒不同
     * nameSecond : 吃v否
     * nameThird : 份日日法人
     * whetherSales : 1
     * whetherManagerAuthority : 0
     * color : #00FF2F
     * whetherReportCount : 1
     * interactiveType : 1
     * whetherFixedAmount : 1
     * payType : 8
     * minPayAmount : 0
     * whetherFreeService : 1
     * whetherTaxExemption : 1
     * whetherSignatureLine : 1
     * paySeq : 1
     * whetherOpenBox : 1
     * getIntegral : 5
     * integralMultiple : 2
     * deductionIntegral : 1
     * dockingType : 0
     * billType : 1,2
     * tablePrintingAmount : 2
     * takeOutPrintingAmount : 2
     * updateTime : 1598674202856
     * createTime : 1598674202856
     * updateUid : 492
     * createUid : 492
     */

    private int id;
    private int brandId;
    private int restaurantId;
    private String nameFirst;
    private String nameSecond;
    private String nameThird;
    /**
     * 銷售營業額(0:非營業額 1：營業額)
     */
    private int whetherSales;
    /**
     * 經理權限
     */
    private int whetherManagerAuthority;
    /**
     * 背景顔色
     */
    private String color = "#FFFFFF";
    /**
     * 字體顔色
     */
    private String font_color = "#000000";
    /**
     * 報表計算人數(0:否 1：是)
     */
    private int whetherReportCount;
    /**
     * 交互方式
     */
    private int interactiveType;
    /**
     * 固定金額 (0:否 1：是)
     */
    private int whetherFixedAmount;
    /**
     * 固定金額數值
     */
    private double amountValue;
    /**
     * 支付方式(1:寶達通 8:支付寶 1001:現金 1023:支付寶HK
     * )
     */
    private int payType;
    /**
     * 最小支付金額（是否有小數點）
     */
    private double minPayAmount;
    /**
     * 是否免服務費(0:否 1：是)
     */
    private int whetherFreeService;
    /**
     * 是否免稅  (0:否 1：是)
     */
    private int whetherTaxExemption;
    /**
     * 是否展示簽署線 (0:否 1：是)
     */
    private int whetherSignatureLine;
    /**
     * 排序
     */
    private int paySeq;
    /**
     * 是否開錢箱(0:否 1：是)
     */
    private int whetherOpenBox;
    /**
     * '獲取積分
     */
    private int getIntegral;
    /**
     * 積分倍數
     */
    private int integralMultiple;
    /**
     * 扣減積分
     */
    private float deductionIntegral;
    /**
     * 對接類型 (0:否 1:yedpay 2:八達通 3:積分 )
     */
    private int dockingType;
    /**
     * 賬單類型(0:否 1：是)
     */
    private String billType;
    /**
     * 櫃檯結賬打印
     */
    private int tablePrintingAmount;
    /**
     * 外賣結賬打印
     */
    private int takeOutPrintingAmount;
    private long updateTime;
    @SerializedName("createTime")
    private long createTimeX;
    private int updateUid;
    private int createUid;


    //*************自定義字段***************
    private double payMoney = 0.0;
    private double TipsPrice = 0.0;
    private int payModeTextColor = Color.parseColor("#000000");
    private int payMoneyTextColor = Color.parseColor("#000000");
    private int payModeTextSelectColor = Color.parseColor("#000000");
    private int payMoneyTextSelectColor = Color.parseColor("#000000");
    private int payModeSize = 14;
    private int payMoneySize = 14;


    public static final int PAY_TYPE_CASH = 1001;
    public static final int PAY_TYPE_INTEGRAL = 2000;

    public PayMethod() {
    }

    public PayMethod(int id, String nameFirst, String nameSecond, String nameThird) {
        this.id = id;
        this.nameFirst = nameFirst;
        this.nameSecond = nameSecond;
        this.nameThird = nameThird;
    }

    public PayMethod(PayMethod method) {
        this.id = method.id;
        this.brandId = method.brandId;
        this.restaurantId = method.restaurantId;
        this.nameFirst = method.nameFirst;
        this.nameSecond = method.nameSecond;
        this.nameThird = method.nameThird;
        this.whetherSales = method.whetherSales;
        this.whetherManagerAuthority = method.whetherManagerAuthority;
        this.color = method.color;
        this.font_color = method.font_color;
        this.whetherReportCount = method.whetherReportCount;
        this.interactiveType = method.interactiveType;
        this.whetherFixedAmount = method.whetherFixedAmount;
        this.amountValue = method.amountValue;
        this.payType = method.payType;
        this.minPayAmount = method.minPayAmount;
        this.whetherFreeService =method. whetherFreeService;
        this.whetherTaxExemption = method.whetherTaxExemption;
        this.whetherSignatureLine =method. whetherSignatureLine;
        this.paySeq = method.paySeq;
        this.whetherOpenBox = method.whetherOpenBox;
        this.getIntegral = method.getIntegral;
        this.integralMultiple =method. integralMultiple;
        this.deductionIntegral =method. deductionIntegral;
        this.dockingType =method. dockingType;
        this.billType = method.billType;
        this.tablePrintingAmount = method.tablePrintingAmount;
        this.takeOutPrintingAmount =method. takeOutPrintingAmount;
        this.updateTime = method.updateTime;
        this.createTimeX = method.createTimeX;
        this.updateUid = method.updateUid;
        this.createUid = method.createUid;
        this.payMoney =method. payMoney;
        this. TipsPrice = method.TipsPrice;
        this.payModeTextColor = method.payModeTextColor;
        this.payMoneyTextColor =method. payMoneyTextColor;
        this.payModeTextSelectColor =method. payModeTextSelectColor;
        this.payMoneyTextSelectColor =method. payMoneyTextSelectColor;
        this.payModeSize =method. payModeSize;
        this.payMoneySize =method. payMoneySize;
    }

    public String getPayName() {
        if (!TextUtils.isEmpty(nameFirst))
            return nameFirst;
        if (!TextUtils.isEmpty(nameSecond))
            return nameSecond;
        if (!TextUtils.isEmpty(nameThird))
            return nameThird;
        return "";
    }

    public void setPayName(String name){
        this.nameFirst = name;
        this.nameSecond = name;
        this.nameThird = name;
    }
}
