package com.gingersoft.gsa.other_order_mode.ui.adapter

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import androidx.databinding.BindingAdapter
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.Adapter
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.data.model.bean.OrderList
import com.gingersoft.gsa.other_order_mode.databinding.LayoutOtherOrderItemBinding

class OtherOrdersAdapter(var context: Context) : Adapter<OtherOrdersAdapter.ViewHolder>() {

    private var databeans: List<OrderList.DataBeanX.DataBean>? = null

    private var listenter: ((item: OrderList.DataBeanX.DataBean) -> Unit)? = null

    fun setOnItemClickListenter(listenter: (item: OrderList.DataBeanX.DataBean) -> Unit) {
        this.listenter = listenter
    }

    fun setData(databeans: List<OrderList.DataBeanX.DataBean>) {
        this.databeans = databeans
        notifyDataSetChanged()
    }


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.layout_other_order_item, parent, false))
    }


    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val data = this.databeans!![position]
        holder.binding.data = data


        var state: String? = null
        val bg = GradientDrawable()
        bg.cornerRadius = 10F
        when {
            data.STATUS == 0 -> {
                state = "待確定"
                bg.setColor(getColor(R.color.order_state0_color))
            }
            data.STATUS == 1 -> {
                state = "待確定"
                bg.setColor(getColor(R.color.order_state0_color))
            }
            data.STATUS == 2 -> {
                state = "製作中"
                bg.setColor(getColor(R.color.order_state1_color))
            }
            data.STATUS == 3 -> {
                state = if (data.order_type == 7) {
                    "待取餐"
                } else {
                    "送貨中"
                }
                bg.setColor(getColor(R.color.order_state2_color))
            }
        }
        holder.binding.state = state
        holder.binding.stateBg = bg

        //堂食外賣背景
        val orderingMethodBg = GradientDrawable()
        orderingMethodBg.shape = GradientDrawable.OVAL
        holder.binding.orderingMethod =
                when {
                    data.order_type == 2 -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state1_color))
                        "外"
                    }
                    data.order_type == 7 -> {
                        orderingMethodBg.setColor(getColor(R.color.self_order_bg))
                        "自"
                    }
                    else -> {
                        orderingMethodBg.setColor(getColor(R.color.order_state1_color))
                        "堂"
                    }
                }
        holder.binding.orderingMethodBg = orderingMethodBg

        //支付方式背景 data.orderPayType==1?@color/table_send:@color/table_use
        //data.orderPayType==1?@string/cash_on_delivery:@string/online_payments
        val payMethodBg = GradientDrawable()
        payMethodBg.cornerRadius = 10F
        holder.binding.payMethod =
                when {
                    data.orderPayType == 1 -> {
                        payMethodBg.setColor(getColor(R.color.cash_on_delivery_bg))
                        "貨到付款"
                    }
                    else -> {
                        payMethodBg.setColor(getColor(R.color.online_payments_bg))
                        "在線支付"
                    }
                }
        holder.binding.payMethodBg = payMethodBg

        holder.itemView.setOnClickListener {
            listenter?.invoke(data)
        }
    }

    override fun getItemCount(): Int {
        return if (databeans == null) {
            0
        } else {
            databeans!!.size
        }
    }

    private fun getColor(color: Int): Int {
        return context.resources.getColor(color)
    }

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var binding: LayoutOtherOrderItemBinding = DataBindingUtil.bind(itemView)!!

        @BindingAdapter("imageUrl")
        fun bindImageUrl(view: ImageView, imageUrl: String) {
            var options: RequestOptions = RequestOptions()
                    .centerCrop()
                    .dontAnimate()

            Glide.with(view)
                    .load(imageUrl)
                    .apply(options)
                    .into(view)
        }
    }
}