package com.gingersoft.gsa.other_order_mode.ui.main

import android.content.Context
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import androidx.fragment.app.FragmentPagerAdapter

/**
 * A [FragmentPagerAdapter] that returns a fragment corresponding to
 * one of the sections/tabs/pages.
 */
class SectionsPagerAdapter(private val context: Context, fm: FragmentManager, var titles: Array<Int>)
    : FragmentPagerAdapter(fm, BEHAVIOR_RESUME_ONLY_CURRENT_FRAGMENT) {
    //BEHAVIOR_SET_USER_VISIBLE_HINT 时，Fragment切换时，会触发setUserVisibleHint。與舊版一致，是廢棄地
    //BEHAVIOR_RESUME_ONLY_CURRENT_FRAGMENT 会用到生命周期状态标识Lifecycle.State。
    //Fragment初始化的时候，默认会执行到onResume()，而AndroidX只会执行到onStart()，所以我们迁移到AndroidX之后
    // ，不需要全都依靠setUserVisibleHint()来判断当前页面是否显示，我们可以根据onResume()来判断。


    override fun getItem(position: Int): Fragment {
        // getItem is called to instantiate the fragment for the given page.
        // Return a PlaceholderFragment (defined as a static inner class below).
        return PlaceholderFragment.newInstance(position)
    }

    override fun getPageTitle(position: Int): CharSequence? {
        return context.resources.getString(titles[position])
    }

    override fun getCount(): Int {
        // Show 5 total pages.
        return 5
    }
}