package com.gingersoft.gsa.cloud.function;

import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.database.bean.Function;

/**
 * 作者：ELEGANT_BIN
 * 版本：1/6/0
 * 创建日期：2020-04-10
 * 修订历史：2020-04-10
 * 描述：每個功能模塊對應的key
 */
public class FunctionModule {

    public static final class Main{
        /**首頁- 點餐*/
        public static final FModule [] order = {
                new FModule("main/order/table",  R.drawable.table_splite,0) ,
                new FModule("main/order/delivery",  R.drawable.table_paper,0) ,
                new FModule("main/order/takeaway",  R.drawable.table_skyorder,0),
                new FModule("main/order/preorder",  R.drawable.table_skyorder,0),
        };
        /**首頁- 管理*/
        public static final FModule [] manager = {
                new FModule("main/manager/bill",  R.drawable.table_splite,0) ,
                new FModule("main/manager/table",  R.drawable.table_paper,0) ,
                new FModule("main/manager/printer",  R.drawable.table_skyorder,0),
                new FModule("main/manager/pay",  R.drawable.table_skyorder,0),
                new FModule("main/manager/discout",  R.drawable.table_skyorder,0)
        };
        /**首頁- 員工管理*/
        public static final FModule [] employee = {
                new FModule("main/employee/management",  R.drawable.table_splite,0) ,
                new FModule("main/employee/delivery",  R.drawable.table_paper,0) ,
                new FModule("main/employee/takeaway",  R.drawable.table_skyorder,0)
        };
    }


    public static final class Table{
        /**餐檯頁*/
        public static final FModule [] bottom = {
                new FModule("table/bottom/init",  R.drawable.table_init,0) ,
                new FModule("table/bottom/move",  R.drawable.table_move,0) ,
                new FModule("table/bottom/splite",  R.drawable.table_splite,0) ,
                new FModule("table/bottom/parper",  R.drawable.table_paper,0) ,
                new FModule("table/bottom/skyorder",  R.drawable.table_skyorder,0)
        };
        /**餐牌頁*/
        public static final FModule [] meal = {
                new FModule("table/meal/plu",  R.drawable.table_paper,0) ,
                new FModule("table/meal/discount",  R.drawable.table_skyorder,0)
        };
        /**賬單內容頁*/
        public static final FModule [] order = {
                new FModule("table/order/send", 0,0) ,
                new FModule("table/order/print",  0,0) ,
                new FModule("table/order/pay",  0,0) ,
                new FModule("table/order/transfer", 0,0) ,
                new FModule("table/order/discount", 0,0)
        };
    }




}
