package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.view.Gravity;
import android.view.View;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.OrderDetailItem;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem3;

import java.util.List;

import androidx.annotation.Nullable;

public class OrderCenterDetailFoodAdapter extends BaseQuickAdapter<SectionTextItem3, BaseViewHolder> {

    public OrderCenterDetailFoodAdapter(@Nullable List<SectionTextItem3> data) {
        super(R.layout.item_order_detail_food, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, SectionTextItem3 item) {
        helper.setText(R.id.tv_left, item.getLeftText());
        if (!item.getCenterText().equals("0")) {
            helper.setText(R.id.tv_center, String.valueOf(item.getCenterText()));
            helper.setVisible(R.id.tv_center, true);
        } else {
            helper.setVisible(R.id.tv_center, false);
        }
        helper.setText(R.id.tv_right, "$" + item.getRightText());
    }

}
