package com.gingersoft.gsa.cloud.database.bean;

import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;

import java.util.Date;
import org.greenrobot.greendao.annotation.Generated;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-04-08
 * 修订历史：2020-04-08
 * 描述：
 */
@Entity
public class Discount {

//    /**
//     * ID
//     */
//    @Property(nameInDb = "_id")
//    @Id(autoincrement = true)
//    private Long id;
//
//    private Integer restaurant_id;
//    /**金額*/
//    private Double amount;
//    /**折扣*/
//    private Double discount_value;
//    /**类型#0:金额;1:折扣;*/
//    private Integer type;
//    /**状态#0:启用;1:禁用;*/
//    private Integer status;
//    /**折扣描述*/
//    private String remark;
//    private Date begin_time;
//    private Date end_time;

    /**
     * ID
     */
    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long id;

    private int restaurant_id;
    /**金額*/
    private double amount;
    /**折扣*/
    private double discount_value;
    /**类型#0:金额;1:折扣;*/
    private int type;
    /**状态#0:启用;1:禁用;*/
    private int status;
    /**折扣描述*/
    private String remark;
    private Date begin_time;
    private Date end_time;

    @Generated(hash = 1370540661)
    public Discount(Long id, int restaurant_id, double amount, double discount_value,
            int type, int status, String remark, Date begin_time, Date end_time) {
        this.id = id;
        this.restaurant_id = restaurant_id;
        this.amount = amount;
        this.discount_value = discount_value;
        this.type = type;
        this.status = status;
        this.remark = remark;
        this.begin_time = begin_time;
        this.end_time = end_time;
    }
    @Generated(hash = 1777606421)
    public Discount() {
    }


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getRestaurant_id() {
        return restaurant_id;
    }

    public void setRestaurant_id(int restaurant_id) {
        this.restaurant_id = restaurant_id;
    }

    public double getAmount() {
        return amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getDiscount_value() {
        return discount_value;
    }

    public void setDiscount_value(double discount_value) {
        this.discount_value = discount_value;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getBegin_time() {
        return begin_time;
    }

    public void setBegin_time(Date begin_time) {
        this.begin_time = begin_time;
    }

    public Date getEnd_time() {
        return end_time;
    }

    public void setEnd_time(Date end_time) {
        this.end_time = end_time;
    }

    /**
     * 計算折扣金額
     * @param discount
     * @param sourcePrice
     * @return
     */
    public static double calculationDiscount(Discount discount , double sourcePrice){
        double discountPrice;
        if(discount.getType() == 0){
            //金額折扣
            discountPrice =  discount.getAmount();
        }else {
            //百分比折扣
            discountPrice = sourcePrice * discount.getDiscount_value();
        }
        if(sourcePrice < discountPrice){
            //折扣金額不能超出總額
            discountPrice = sourcePrice;
        }
//        else {
//            discountPrice = sourcePrice - discountPrice;
//        }
        return -MoneyUtil.get_ItemDecimals_money(discountPrice);
    }

}
