package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "PRINT_CURRENCY_BEAN".
*/
public class PrintCurrencyBeanDao extends AbstractDao<PrintCurrencyBean, Long> {

    public static final String TABLENAME = "PRINT_CURRENCY_BEAN";

    /**
     * Properties of entity PrintCurrencyBean.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", false, "ID");
        public final static Property Dbid = new Property(1, Long.class, "dbid", true, "_id");
        public final static Property Name = new Property(2, String.class, "name", false, "NAME");
        public final static Property RestaurantId = new Property(3, Integer.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property Type = new Property(4, int.class, "type", false, "TYPE");
        public final static Property FoodComplexion = new Property(5, int.class, "foodComplexion", false, "FOOD_COMPLEXION");
        public final static Property ModifierComplexion = new Property(6, int.class, "modifierComplexion", false, "MODIFIER_COMPLEXION");
        public final static Property Deletes = new Property(7, int.class, "deletes", false, "DELETES");
        public final static Property Uid = new Property(8, Integer.class, "uid", false, "UID");
        public final static Property CreateTime = new Property(9, Long.class, "createTime", false, "CREATE_TIME");
        public final static Property UpdateTime = new Property(10, Long.class, "updateTime", false, "UPDATE_TIME");
        public final static Property FontId = new Property(11, Long.class, "fontId", false, "FONT_ID");
        public final static Property FoodIsBold = new Property(12, int.class, "foodIsBold", false, "FOOD_IS_BOLD");
        public final static Property FoodFont = new Property(13, String.class, "foodFont", false, "FOOD_FONT");
        public final static Property FoodIsItalic = new Property(14, int.class, "foodIsItalic", false, "FOOD_IS_ITALIC");
        public final static Property ModifierIsBold = new Property(15, int.class, "modifierIsBold", false, "MODIFIER_IS_BOLD");
        public final static Property ModifierFont = new Property(16, String.class, "modifierFont", false, "MODIFIER_FONT");
        public final static Property ModifierIsItalic = new Property(17, int.class, "modifierIsItalic", false, "MODIFIER_IS_ITALIC");
        public final static Property NumberIsFlip = new Property(18, int.class, "numberIsFlip", false, "NUMBER_IS_FLIP");
    }


    public PrintCurrencyBeanDao(DaoConfig config) {
        super(config);
    }
    
    public PrintCurrencyBeanDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"PRINT_CURRENCY_BEAN\" (" + //
                "\"ID\" INTEGER," + // 0: id
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 1: dbid
                "\"NAME\" TEXT," + // 2: name
                "\"RESTAURANT_ID\" INTEGER," + // 3: restaurantId
                "\"TYPE\" INTEGER NOT NULL ," + // 4: type
                "\"FOOD_COMPLEXION\" INTEGER NOT NULL ," + // 5: foodComplexion
                "\"MODIFIER_COMPLEXION\" INTEGER NOT NULL ," + // 6: modifierComplexion
                "\"DELETES\" INTEGER NOT NULL ," + // 7: deletes
                "\"UID\" INTEGER," + // 8: uid
                "\"CREATE_TIME\" INTEGER," + // 9: createTime
                "\"UPDATE_TIME\" INTEGER," + // 10: updateTime
                "\"FONT_ID\" INTEGER," + // 11: fontId
                "\"FOOD_IS_BOLD\" INTEGER NOT NULL ," + // 12: foodIsBold
                "\"FOOD_FONT\" TEXT," + // 13: foodFont
                "\"FOOD_IS_ITALIC\" INTEGER NOT NULL ," + // 14: foodIsItalic
                "\"MODIFIER_IS_BOLD\" INTEGER NOT NULL ," + // 15: modifierIsBold
                "\"MODIFIER_FONT\" TEXT," + // 16: modifierFont
                "\"MODIFIER_IS_ITALIC\" INTEGER NOT NULL ," + // 17: modifierIsItalic
                "\"NUMBER_IS_FLIP\" INTEGER NOT NULL );"); // 18: numberIsFlip
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"PRINT_CURRENCY_BEAN\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, PrintCurrencyBean entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(2, dbid);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(3, name);
        }
 
        Integer restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
        stmt.bindLong(5, entity.getType());
        stmt.bindLong(6, entity.getFoodComplexion());
        stmt.bindLong(7, entity.getModifierComplexion());
        stmt.bindLong(8, entity.getDeletes());
 
        Integer uid = entity.getUid();
        if (uid != null) {
            stmt.bindLong(9, uid);
        }
 
        Long createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(10, createTime);
        }
 
        Long updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(11, updateTime);
        }
 
        Long fontId = entity.getFontId();
        if (fontId != null) {
            stmt.bindLong(12, fontId);
        }
        stmt.bindLong(13, entity.getFoodIsBold());
 
        String foodFont = entity.getFoodFont();
        if (foodFont != null) {
            stmt.bindString(14, foodFont);
        }
        stmt.bindLong(15, entity.getFoodIsItalic());
        stmt.bindLong(16, entity.getModifierIsBold());
 
        String modifierFont = entity.getModifierFont();
        if (modifierFont != null) {
            stmt.bindString(17, modifierFont);
        }
        stmt.bindLong(18, entity.getModifierIsItalic());
        stmt.bindLong(19, entity.getNumberIsFlip());
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, PrintCurrencyBean entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(2, dbid);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(3, name);
        }
 
        Integer restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
        stmt.bindLong(5, entity.getType());
        stmt.bindLong(6, entity.getFoodComplexion());
        stmt.bindLong(7, entity.getModifierComplexion());
        stmt.bindLong(8, entity.getDeletes());
 
        Integer uid = entity.getUid();
        if (uid != null) {
            stmt.bindLong(9, uid);
        }
 
        Long createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(10, createTime);
        }
 
        Long updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(11, updateTime);
        }
 
        Long fontId = entity.getFontId();
        if (fontId != null) {
            stmt.bindLong(12, fontId);
        }
        stmt.bindLong(13, entity.getFoodIsBold());
 
        String foodFont = entity.getFoodFont();
        if (foodFont != null) {
            stmt.bindString(14, foodFont);
        }
        stmt.bindLong(15, entity.getFoodIsItalic());
        stmt.bindLong(16, entity.getModifierIsBold());
 
        String modifierFont = entity.getModifierFont();
        if (modifierFont != null) {
            stmt.bindString(17, modifierFont);
        }
        stmt.bindLong(18, entity.getModifierIsItalic());
        stmt.bindLong(19, entity.getNumberIsFlip());
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1);
    }    

    @Override
    public PrintCurrencyBean readEntity(Cursor cursor, int offset) {
        PrintCurrencyBean entity = new PrintCurrencyBean( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // dbid
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // name
            cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3), // restaurantId
            cursor.getInt(offset + 4), // type
            cursor.getInt(offset + 5), // foodComplexion
            cursor.getInt(offset + 6), // modifierComplexion
            cursor.getInt(offset + 7), // deletes
            cursor.isNull(offset + 8) ? null : cursor.getInt(offset + 8), // uid
            cursor.isNull(offset + 9) ? null : cursor.getLong(offset + 9), // createTime
            cursor.isNull(offset + 10) ? null : cursor.getLong(offset + 10), // updateTime
            cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11), // fontId
            cursor.getInt(offset + 12), // foodIsBold
            cursor.isNull(offset + 13) ? null : cursor.getString(offset + 13), // foodFont
            cursor.getInt(offset + 14), // foodIsItalic
            cursor.getInt(offset + 15), // modifierIsBold
            cursor.isNull(offset + 16) ? null : cursor.getString(offset + 16), // modifierFont
            cursor.getInt(offset + 17), // modifierIsItalic
            cursor.getInt(offset + 18) // numberIsFlip
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, PrintCurrencyBean entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setDbid(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setName(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setRestaurantId(cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3));
        entity.setType(cursor.getInt(offset + 4));
        entity.setFoodComplexion(cursor.getInt(offset + 5));
        entity.setModifierComplexion(cursor.getInt(offset + 6));
        entity.setDeletes(cursor.getInt(offset + 7));
        entity.setUid(cursor.isNull(offset + 8) ? null : cursor.getInt(offset + 8));
        entity.setCreateTime(cursor.isNull(offset + 9) ? null : cursor.getLong(offset + 9));
        entity.setUpdateTime(cursor.isNull(offset + 10) ? null : cursor.getLong(offset + 10));
        entity.setFontId(cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11));
        entity.setFoodIsBold(cursor.getInt(offset + 12));
        entity.setFoodFont(cursor.isNull(offset + 13) ? null : cursor.getString(offset + 13));
        entity.setFoodIsItalic(cursor.getInt(offset + 14));
        entity.setModifierIsBold(cursor.getInt(offset + 15));
        entity.setModifierFont(cursor.isNull(offset + 16) ? null : cursor.getString(offset + 16));
        entity.setModifierIsItalic(cursor.getInt(offset + 17));
        entity.setNumberIsFlip(cursor.getInt(offset + 18));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(PrintCurrencyBean entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(PrintCurrencyBean entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(PrintCurrencyBean entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
