package com.gingersoft.gsa.delivery_pick_mode.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.delivery_pick_mode.di.module.AddressListModule;
import com.gingersoft.gsa.delivery_pick_mode.mvp.contract.AddressListContract;

import com.jess.arms.di.scope.ActivityScope;
import com.gingersoft.gsa.delivery_pick_mode.mvp.ui.activity.AddressListActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 10/16/2020 15:53
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = AddressListModule.class, dependencies = AppComponent.class)
public interface AddressListComponent {
    void inject(AddressListActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        AddressListComponent.Builder view(AddressListContract.View view);

        AddressListComponent.Builder appComponent(AppComponent appComponent);

        AddressListComponent build();
    }
}