package com.gingersoft.gsa.cloud.base.order.bean.discount;

import com.gingersoft.gsa.cloud.base.order.billItem.DiscountItem;
import com.gingersoft.gsa.cloud.base.order.discount.MemberDiscount;
import com.gingersoft.gsa.cloud.base.order.discount.NomalDiscount;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.database.bean.Discount;

import java.io.Serializable;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-22
 * 修订历史：2020-09-22
 * 描述：
 */
public class OrderDiscount {

    public static final int ORDER_DISCOUNT = 0;
    public static final int MEMBER_DISCOUNT = 1;
    public static final int COUPON_DISCOUNT = 2;

    @Data
    public static class Request {

        /**
         * 0#餐廳折扣
         * 1#會員折扣
         * 2#优惠券折扣
         */
        private int type;
        /**
         * 折扣ID
         */
        private Long discountId;
        /**
         * 會員折扣ID
         */
        private Long memberId;
        /**
         * 會員折扣比例
         */
        private Integer memberDiscountRate;
        /**
         * 折扣金額
         */
        private double discountAmount;
        /**
         * 是否计算服务费
         */
        private int scAble;

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public Long getDiscountId() {
            return discountId;
        }

        public void setDiscountId(Long discountId) {
            this.discountId = discountId;
        }

        public Long getMemberId() {
            return memberId;
        }

        public void setMemberId(Long memberId) {
            this.memberId = memberId;
        }

        public Integer getMemberDiscountRate() {
            return memberDiscountRate;
        }

        public void setMemberDiscountRate(Integer memberDiscountRate) {
            this.memberDiscountRate = memberDiscountRate;
        }

        public double getDiscountAmount() {
            return discountAmount;
        }

        public void setDiscountAmount(double discountAmount) {
            this.discountAmount = discountAmount;
        }

        public int getScAble() {
            return scAble;
        }

        public void setScAble(int scAble) {
            this.scAble = scAble;
        }

        public static Request orderDiscountTransRequest(DiscountItem discount) {
            Request request = new Request();
            request.setType(ORDER_DISCOUNT);
            if(discount.getDiscount() != null) {
                NomalDiscount discount1 = (NomalDiscount) discount.getDiscount();
                request.setDiscountId(discount1.getDiscount().getId());
            }
            request.setDiscountAmount(discount.getMoney());
            request.setScAble(0);
            return request;
        }

        public static Request memberDiscountTransRequest(DiscountItem discount) {
            Request request = new Request();
            request.setType(MEMBER_DISCOUNT);
            if(discount.getDiscount() != null) {
                MemberDiscount memberDiscount = (MemberDiscount) discount.getDiscount();
                request.setMemberId(memberDiscount.getMemberDiscount().getId());
//                request.setMemberDiscountRate((int) memberDiscount.getDiscount().getDiscount_value());
            }
            request.setDiscountAmount(discount.getMoney());
            request.setScAble(0);
            return request;
        }

        public static Request couponDiscountTransRequest(DiscountItem discount) {
            Request request = new Request();
            request.setType(COUPON_DISCOUNT);
            if(discount.getDiscount() != null) {
//                request.setMemberId(discount.getDiscount().getMemberId());
//                request.setDiscountId(discount.getDiscount().getId());
//                request.setMemberDiscountRate((int) discount.getDiscount().getDiscount_value());
            }
            request.setDiscountAmount(discount.getMoney());
            request.setScAble(0);
            return request;
        }
    }

    @Data
    public static class Respose implements Serializable {

        /**
         * 餐廳折扣ID
         */
        private Long discountId;
        /**折扣金額*/
        private double discountAmount;
        /**折扣比例*/
        private int discountValue;
        /**
         * 0#餐廳折扣
         * 1#會員折扣
         * 2#优惠券折扣
         */
        private int type;
        /**
         * 餐廳折扣類型 0：金額，1：折扣，2：自定義金額，3：自由金額，數字盤，4：免服務費
         */
        private byte discountType;
        /**折扣名称1*/
        private String remark;
        /**折扣名称2*/
        private String remark2;
        /**折扣名称3*/
        private String remark3;

        /**
         * 优惠券折扣相关
         */
        // 消費滿
        private Double spend;
        // 是否累計滿減：0否，1是
        private Byte accumulate;


    }

}
