package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.base.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.PrjBean;
import com.joe.print.mvp.ui.adapter.KitChenPrjPrintFoodAdapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 廚房單打印
 */
public class PrintPrjKitchen extends PrinterRoot {

    private static Map<String, List<PrjBean.DataBean.Bean>> prjMap;

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        //通過打印位置生成多張用於打印的bitmap
        for (Map.Entry<String, List<PrjBean.DataBean.Bean>> entry : getPrjMap().entrySet()) {
            String key = entry.getKey();
            List<Bitmap> bitmaps = new ArrayList<>();

            List<PrjBean.DataBean.Bean> noCut = new ArrayList<>();
            //不帶*號，所有同樣廚房位置的食品都在一張紙上
            for (PrjBean.DataBean.Bean bean : entry.getValue()) {
                if (bean.getStatus() == 2) {
                    List<PrjBean.DataBean.Bean> beans = new ArrayList<>();
                    beans.add(bean);
                    Bitmap bitmap = getKitChenPrintBitmap(mContext, key, beans, deviceBean);
                    bitmaps.add(bitmap);
                } else {
                    noCut.add(bean);
                }
            }
            if (noCut.size() > 0) {
                Bitmap bitmap = getKitChenPrintBitmap(mContext, key, noCut, deviceBean);
                bitmaps.add(bitmap);
            }
            bitmapMaps.put(key, bitmaps);
        }
        prjMap.clear();
        return bitmapMaps;
    }

    @Override
    public String getPrintData(Context mContext, PrinterDeviceBean deviceBean) {
        return null;
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }

    public Bitmap getKitChenPrintBitmap(Context context, String key, PrjBean.DataBean.Bean data, PrinterDeviceBean printerDeviceBean) {
        List<PrjBean.DataBean.Bean> beans = new ArrayList<>();
        beans.add(data);
        return getKitChenPrintBitmap(context, key, beans, printerDeviceBean);
    }

    /**
     * 獲取"廚房單"圖片
     *
     * @param context
     * @return
     */
    public Bitmap getKitChenPrintBitmap(Context context, String key, List<PrjBean.DataBean.Bean> data, PrinterDeviceBean printerDeviceBean) {
        if (data == null || data.size() <= 0) {
            return null;
        }
        PrjBean.DataBean.Bean prjBean = data.get(0);
        if (prjBean == null) {
            return null;
        }
        for (PrjBean.DataBean.Bean bean : data) {
            if (bean.getParentId() == 0) {
                //沒有父級id，則是第一級食品
                bean.setItemType(1);
            }
            //如果父級id不為0，是細項
            if (bean.getParentId() != 0) {
                bean.setItemType(2);//先設置為細項，再通過下面的遍歷確定是否是第三級細項
                //循環遍歷查找父級食品
                for (PrjBean.DataBean.Bean itembean : data) {
                    if (bean.getParentId() == itembean.getOrderDetailsId()) {
                        //如果父級是細項，則當前食品就是二級細項
                        bean.setItemType(bean.getItemType() + 1);
                        break;
                    }
                }
            }
        }
        View view = LinearLayout.inflate(context, R.layout.print_kitchen, null);
        TextView tvTableNumber = view.findViewById(R.id.tv_kitchen_print_table_number);
        TextView tvOrderNumberText = view.findViewById(R.id.tv_order_num_text);
        TextView tvOrderNumber = view.findViewById(R.id.tv_order_num);
        TextView tvTakeCodeText = view.findViewById(R.id.tv_take_code_text);
        TextView tvTakeCode = view.findViewById(R.id.tv_take_code);
        TextView tvTakeTime = view.findViewById(R.id.tv_food_time);
        TextView tvOpeningTime = view.findViewById(R.id.tv_opening_time);
        TextView tvOrderTime = view.findViewById(R.id.tv_order_time);
        TextView tvKitChenLocation = view.findViewById(R.id.tv_kitchen_location);
        TextView tvPeople = view.findViewById(R.id.tv_people);
        TextView tvOperator = view.findViewById(R.id.tv_operator);
        TextView tvCurrentPageIndex = view.findViewById(R.id.tv_prj_page_index);
        RecyclerView rvFood = view.findViewById(R.id.rv_kitchen_food);
        TextView tvTableNumber2 = view.findViewById(R.id.tv_kitchen_print_table_number2);
        TextView tvFirstOrder = view.findViewById(R.id.tv_kitchen_print_first_order);
        TextView tvPrintQuantity = view.findViewById(R.id.tv_kitchen_print_quantity);

        LinearLayout layoutOpenTableTime = view.findViewById(R.id.layout_opening_table_time);

        KitChenPrjPrintFoodAdapter foodAdapter = new KitChenPrjPrintFoodAdapter(data, printerDeviceBean);
        rvFood.setLayoutManager(new LinearLayoutManager(context));
        rvFood.setAdapter(foodAdapter);
        //廚房位置
        if (!TextUtil.isEmptyOrNullOrUndefined(key) && !key.equals("-1")) {
            tvKitChenLocation.setText(key + "廚房");//.replace("*", "")
            tvKitChenLocation.setVisibility(View.VISIBLE);
        } else {
            tvKitChenLocation.setVisibility(View.GONE);
        }
        if (!TextUtil.isEmptyOrNullOrUndefined(prjBean.getBillNo())) {
            //訂單碼不為空
            tvOrderNumberText.setText("訂單碼：");
            tvOrderNumber.setText(prjBean.getBillNo());
        } else {
            //訂單號
            tvOrderNumber.setText(prjBean.getOrderNo());
        }
        if (TextUtil.isEmptyOrNullOrUndefined(prjBean.getTableName())) {
            layoutOpenTableTime.setVisibility(View.GONE);
            if (prjBean.getOrderType() == 7) {
                tvTableNumber.setText("自取");
                tvTableNumber2.setText("自取");
                if (!TextUtil.isEmptyOrNullOrUndefined(prjBean.getTakeFoodCode())) {
                    tvTakeCodeText.setVisibility(View.VISIBLE);
                    tvTakeCode.setVisibility(View.VISIBLE);
                    tvTakeCode.setText(prjBean.getTakeFoodCode());
                }
            } else {
                tvTableNumber.setText("外賣");
                tvTableNumber2.setText("外賣");
                tvOrderNumberText.setText("訂單碼：");
                tvOrderNumber.setText(prjBean.getTakeFoodCode());
            }
        } else {
            tvTableNumber.setText(prjBean.getTableName());
            tvTableNumber2.setText(prjBean.getTableName());
        }
        //人數
        if (prjBean.getPerson() != 0) {
            tvPeople.setText(prjBean.getPerson() + "");
            view.findViewById(R.id.tv_people_text).setVisibility(View.VISIBLE);
            view.findViewById(R.id.tv_people).setVisibility(View.VISIBLE);
        }
        if (TextUtil.isNotEmptyOrNullOrUndefined(prjBean.getTakeTime())) {
            tvTakeTime.setText("取餐時間：" + prjBean.getTakeTime());
        } else if (TextUtil.isNotEmptyOrNullOrUndefined(prjBean.getSendTime())) {
            tvTakeTime.setText("送達時間：" + prjBean.getSendTime());
        } else {
            tvTakeTime.setVisibility(View.GONE);
        }
        if (RestaurantExpandInfoUtils.getValue(ExpandConstant.PrintFirstOrder, false)) {
            tvFirstOrder.setText("<頭單>");
            tvFirstOrder.setVisibility(prjBean.getIsFirstSendOrder() == 1 ? View.VISIBLE : View.GONE);
        } else {
            tvFirstOrder.setVisibility(View.GONE);
        }

        if (RestaurantExpandInfoUtils.getValue(ExpandConstant.PrintStatisticsAmount, false)) {
            tvPrintQuantity.setText(prjBean.getQuantity() + "");
        } else {
            tvPrintQuantity.setVisibility(View.GONE);
        }
        //開台時間
        tvOpeningTime.setText(TimeUtils.parseTimeRepeat(prjBean.getOrderDetailsTime(), TimeUtils.DEFAULT_DATE_MDHM));

//        if (OpenTableManage.getDefault().getTableBean() != null) {
//            //台號
//            tvTableNumber.setText(prjBean.getTableName());
//            tvTableNumber2.setText(prjBean.getTableName());
//            //人數
//            tvPeople.setText(prjBean.getPerson() + "");
//            //訂單號
//            tvOrderNumber.setText(prjBean.getOrderNo());
//            //開台時間
//            tvOpeningTime.setText(TimeUtils.parseTimeRepeat(prjBean.getOrderDetailsTime(), TimeUtils.DEFAULT_DATE_FORMAT));
//        }
        //落單時間，為當前時間
        tvOrderTime.setText(TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_MDHM));
        //操作人員
        tvOperator.setText(prjBean.getUserName());
        if (RestaurantExpandInfoUtils.getValue(ExpandConstant.PrintPage, false)) {
            tvCurrentPageIndex.setText(prjBean.getCurrentIndex() + "/" + prjBean.getTotalPrj());
        }
        return viewToZoomBitmap(context, view, printerDeviceBean);
    }


    public static Map<String, List<PrjBean.DataBean.Bean>> getPrjMap() {
        if (prjMap == null) {
            prjMap = new HashMap<>();
        }
        return prjMap;
    }
}
