package com.gingersoft.gsa.cloud.base.utils;

import android.text.TextUtils;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.config.expandInfo.ExpandInfoSetting;
import com.gingersoft.gsa.cloud.config.expandInfo.FunctionExtendedConfiguration;
import com.gingersoft.gsa.cloud.config.expandInfo.UIStyleExtendedConfiguration;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.ExpandInfo;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-05-11
 * 修订历史：2020-05-11
 * 描述：餐廳擴展信息工具類
 */
public class RestaurantExpandInfoUtils {

    public final static String VALUE_INT = "valueInt";
    public final static String VALUE_CHAR = "valueChar";
    public final static String VALUE_DATETIME = "valueDatetime";
    public final static String VALUE_DATETIME2 = "valueDatetime2";
    public final static String REMARK = "remark";

    private static Map<String, Object> map = new HashMap<>();
    private static Map<String, Long> idMaps = new HashMap<>();

    /**
     * 保存常用信息
     *
     * @param expandInfoList
     */
    public static void setCommonExpandInfo(List<ExpandInfo> expandInfoList) {
        for (ExpandInfo expandInfo : expandInfoList) {
            switch (expandInfo.getSettingName()) {
                case ExpandConstant.Rounding:
                    MoneyUtil.rounding = expandInfo.getValueInt();
                    break;
                case ExpandConstant.RoundingDecimal:
                    MoneyUtil.RoundingDecimal = expandInfo.getValueInt();
                    break;
                case ExpandConstant.ItemDecimals:
                    MoneyUtil.ItemDecimals = expandInfo.getValueInt();
                    break;
                case ExpandConstant.ToPrintQRCode:
                case ExpandConstant.MergeSendFood:
                case ExpandConstant.AutoPrinterPaper:
                case ExpandConstant.PrintMemberInfo:
                case ExpandConstant.PrintPage:
                case ExpandConstant.PrintMergerFood:
                case ExpandConstant.PrintStatisticsAmount:
                case ExpandConstant.PrintFirstOrder:
                case ExpandConstant.FrozenChainAutoOrder:
                    map.put(expandInfo.getSettingName(), expandInfo.getValueInt() == 0);
                    idMaps.put(expandInfo.getSettingName(), expandInfo.getId());
                    break;
                case ExpandConstant.OrderReceivingTimeout:
                case ExpandConstant.DeliveryPrintCount:
                case ExpandConstant.DeliveryClosingPC:
                case ExpandConstant.TableModePrintCount:
                case ExpandConstant.TableModeClosingPC:
                    map.put(expandInfo.getSettingName(), expandInfo.getValueInt());
                    idMaps.put(expandInfo.getSettingName(), expandInfo.getId());
                    break;
            }
        }

        for (ExpandInfo expandInfo : expandInfoList) {
            if (expandInfo.getDataType() == ExpandInfo.data_type_int) {
                map.put(expandInfo.getSettingName(), expandInfo.getValueInt());
            } else if (expandInfo.getDataType() == ExpandInfo.data_type_string) {
                map.put(expandInfo.getSettingName(), expandInfo.getValueChar());
            } else if (expandInfo.getDataType() == ExpandInfo.data_type_boolean) {
                map.put(expandInfo.getSettingName(), expandInfo.getValueInt() == 0);
            } else if (expandInfo.getDataType() == ExpandInfo.data_type_date) {
                map.put(expandInfo.getSettingName(), expandInfo.getValueDatetime());
            } else {
                //之前的老數據 默認DataType == 0
                if (expandInfo.getValueInt() != null) {
                    map.put(expandInfo.getSettingName(), expandInfo.getValueInt());
                } else if (!TextUtils.isEmpty(expandInfo.getValueChar())) {
                    map.put(expandInfo.getSettingName(), expandInfo.getValueChar());
                } else if (!TextUtils.isEmpty(expandInfo.getValueDatetime())) {
                    map.put(expandInfo.getSettingName(), expandInfo.getValueDatetime());
                }
            }
        }

        UIStyleExtendedConfiguration uiStyleConfiguration = GsaCloudApplication.uiStyleConfiguration;
        Field uiFields[] = uiStyleConfiguration.getClass().getDeclaredFields();
        for (Field field : uiFields) {
            String expandinfoName = field.getName();
            if (map.containsKey(expandinfoName)) {
                Object value = map.get(expandinfoName);
                try {
                    field.setAccessible(true);
                    ExpandInfoSetting expandInfo = (ExpandInfoSetting) field.get(uiStyleConfiguration);
                    boolean typeMatch = (value instanceof Integer && expandInfo.getDataType() == 1) ||
                            (value instanceof String && (expandInfo.getDataType() == 2 || expandInfo.getDataType() == 4)) ||
                            (value instanceof Boolean && expandInfo.getDataType() == 3);
                    if (!typeMatch) {
                        //後台配置的類型與前端的不一致 直接不管
                        continue;
                    }
                    if (expandInfo.getDataType() == 1) {
                        expandInfo.setValueInt((Integer) value);
                    } else if (expandInfo.getDataType() == 2) {
                        expandInfo.setValueChar((String) value);
                    } else if (expandInfo.getDataType() == 3) {
                        expandInfo.setValueBoolean((Boolean) value);
                    } else if (expandInfo.getDataType() == 4) {
                        expandInfo.setValueDateTime((String) value);
                    }
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        FunctionExtendedConfiguration functionConfiguration = GsaCloudApplication.functionConfiguration;
        Field functionFields[] = functionConfiguration.getClass().getDeclaredFields();
        for (Field field : functionFields) {
            String expandinfoName = field.getName();
            if (map.containsKey(expandinfoName)) {
                Object value = map.get(expandinfoName);
                try {
                    field.setAccessible(true);
                    ExpandInfoSetting expandInfo = (ExpandInfoSetting) field.get(functionConfiguration);
                    boolean typeMatch = (value instanceof Integer && expandInfo.getDataType() == 1) ||
                            (value instanceof String && (expandInfo.getDataType() == 2 || expandInfo.getDataType() == 4)) ||
                            (value instanceof Boolean && expandInfo.getDataType() == 3);
                    if (!typeMatch) {
                        //後台配置的類型與前端的不一致 直接不管
                        continue;
                    }
                    if (expandInfo.getDataType() == 1) {
                        expandInfo.setValueInt((Integer) value);
                    } else if (expandInfo.getDataType() == 2) {
                        expandInfo.setValueChar((String) value);
                    } else if (expandInfo.getDataType() == 3) {
                        expandInfo.setValueBoolean((Boolean) value);
                    } else if (expandInfo.getDataType() == 4) {
                        expandInfo.setValueDateTime((String) value);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        int i = 100;
    }


    public static <T> T getValue(String name, Object defaultValue) {
        if (map != null && map.containsKey(name)) {
            if (defaultValue instanceof Boolean) {
                if (map.get(name) instanceof Boolean) {
                    return (T) map.get(name);
                } else if (map.get(name) instanceof Integer) {
                    map.put(name, (int) map.get(name) == 0);
                } else {
                    return (T) defaultValue;
                }
            }
            return (T) map.get(name);
        } else {
            return (T) defaultValue;
        }
    }

    public static void setValue(String name, Object value) {
        map.put(name, value);
    }

    public static Long getId(String name) {
        return idMaps.get(name);
    }
}
