package com.gingersoft.gsa.cloud.base.utils;

import android.content.Context;
import android.text.TextUtils;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.ui.bean.mode.BrandsBean;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-12
 * 修订历史：2020-03-12
 * 描述：
 */
public class RestaurantInfoUtils {

    public static List<BrandsBean.BrandsData> getBrandList() {
        String brandRestaurantInfos = GsaCloudApplication.getBrandRestaurantInfo();
        if (!TextUtils.isEmpty(brandRestaurantInfos)) {
            List<BrandsBean.BrandsData> brandsBeans = JsonUtils.parseArray(brandRestaurantInfos, BrandsBean.BrandsData.class);
            return brandsBeans;
        }
        return new ArrayList<>();
    }

    public static int getRestaurantSize(Context context) {
        int size = 0;
        List<BrandsBean.BrandsData> brandsBeans = getBrandList();
        if (brandsBeans == null) {
            return 0;
        }
        for (int i = 0; i < brandsBeans.size(); i++) {
            if (brandsBeans.get(i).getRestaurants() != null)
                size += brandsBeans.get(i).getRestaurants().size();
        }
        return size;
    }

    public static int getRestaurantSize(List<BrandsBean.BrandsData> brands) {
        if (brands == null) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null)
                size += brands.get(i).getRestaurants().size();
        }
        return size;
    }

    public static BrandsBean.BrandsData getOnlyBrand(List<BrandsBean.BrandsData> brands) {
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null) {
                return brands.get(i);
            }
        }
        return null;
    }

    public static BrandsBean.BrandsData.RestaurantsBean getOnlyRestaurant(List<BrandsBean.BrandsData> brands) {
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null) {
                for (int j = 0; j < brands.get(i).getRestaurants().size(); j++) {
                    return brands.get(i).getRestaurants().get(j);
                }
            }
        }
        return null;
    }

    public static BrandsBean.BrandsData getBrandByRestaurantId(List<BrandsBean.BrandsData> brands, int restaurantId) {
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null) {
                for (int j = 0; j < brands.get(i).getRestaurants().size(); j++) {
                    if (brands.get(i).getRestaurants().get(j).getRestaurantId() == restaurantId) {
                        return brands.get(i);
                    }
                }
            }
        }
        return null;
    }
}
