package com.gingersoft.gsa.cloud.config.globalconfig;

import android.app.Application;
import android.content.Context;

import androidx.fragment.app.FragmentManager;

import com.gingersoft.gsa.cloud.config.globalconfig.applyOptions.MyGlobalHttpHandler;
import com.gingersoft.gsa.cloud.config.globalconfig.applyOptions.MyGsonConfiguration;
import com.gingersoft.gsa.cloud.config.globalconfig.applyOptions.MyOkhttpConfiguration;
import com.gingersoft.gsa.cloud.config.globalconfig.applyOptions.MyResponseErrorListener;
import com.gingersoft.gsa.cloud.config.globalconfig.applyOptions.MyRetrofitConfiguration;
import com.gingersoft.gsa.cloud.config.globalconfig.applyOptions.MyRxCacheConfiguration;
import com.gingersoft.gsa.cloud.config.globalconfig.lifecyclesOptioins.MyActivityLifecycle;
import com.gingersoft.gsa.cloud.config.globalconfig.lifecyclesOptioins.MyAppLifecycles;
import com.gingersoft.gsa.cloud.constans.HttpsConstans;
import com.jess.arms.base.delegate.AppLifecycles;
import com.jess.arms.di.module.GlobalConfigModule;
import com.jess.arms.integration.ConfigModule;
import com.jess.arms.utils.DataHelper;

import java.io.File;
import java.util.List;

public class GlobalConfiguration implements ConfigModule {

    @Override
    public void applyOptions(Context context, GlobalConfigModule.Builder builder) {
        //使用builder可以为框架配置一些配置信息
        builder
                .baseurl(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL)
                .okhttpConfiguration(new MyOkhttpConfiguration())
                .retrofitConfiguration(new MyRetrofitConfiguration())
                .globalHttpHandler(new MyGlobalHttpHandler())
                .responseErrorListener(new MyResponseErrorListener())
                .rxCacheConfiguration(new MyRxCacheConfiguration())
                .cacheFile(new File(DataHelper.getCacheFile(context), "rxCache"))
                .gsonConfiguration(new MyGsonConfiguration());
    }

    @Override
    public void injectAppLifecycle(Context context, List<AppLifecycles> lifecycles) {
        //向Application的生命周期中注入一些自定义逻辑
        lifecycles.add(new MyAppLifecycles());
    }


    @Override
    public void injectActivityLifecycle(Context context, List<Application.ActivityLifecycleCallbacks> lifecycles) {
        //向Activity的生命周期中注入一些自定义逻辑
        lifecycles.add(new MyActivityLifecycle());
    }


    @Override
    public void injectFragmentLifecycle(Context context, List<FragmentManager.FragmentLifecycleCallbacks> lifecycles) {
        //向Fragment的生命周期中注入一些自定义逻辑
    }


}