package com.gingersoft.gsa.cloud.ui.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.net.ParseException;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.gingersoft.gsa.cloud.base.R;

import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.ui.widget.dialog.DialogAnimationListener;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.DeviceUtils;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUIEmptyView;
import com.qmuiteam.qmui.widget.QMUITopBar;

import org.json.JSONException;

import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-07-29
 * 修订历史：2020-07-29
 * 描述：
 */
public abstract class BaseRetryDialog extends Dialog {

    private static final String TAG = "BaseRetryDialog";
    private Context mContext;

    private OnRetryListener onRetryListener;
    protected DialogAnimationListener dialogAnimationListener;

    public BaseRetryDialog(@NonNull Context context,int style) {
        super(context, style);
        mContext = context;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setCanceledOnTouchOutside(true);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void dismiss() {
        super.dismiss();
    }

    protected void showEmptyView(boolean isSuccess, int size, Throwable t, QMUIEmptyView emptyView, RecyclerView recyclerView) {
        if (t != null) {
            if (t instanceof UnknownHostException) {
                //沒有網絡
                emptyView.show(false, mContext.getResources().getString(R.string.emptyView_mode_desc_fail_title), mContext.getResources().getString(R.string.emptyView_mode_desc_fail_desc), mContext.getResources().getString(R.string.emptyView_mode_desc_retry), onRetryClickListener);
            } else if (t instanceof SocketTimeoutException) {
                //請求超時
                emptyView.show(false, mContext.getResources().getString(R.string.emptyView_mode_desc_fail_title), mContext.getResources().getString(R.string.emptyView_mode_desc_fail_desc), mContext.getResources().getString(R.string.emptyView_mode_desc_retry), onRetryClickListener);
            } else if (t instanceof JsonParseException || t instanceof ParseException || t instanceof JSONException || t instanceof JsonIOException) {
                //數據解析錯誤
                emptyView.show(false, mContext.getResources().getString(R.string.response_error_data_parsing_error), null, mContext.getResources().getString(R.string.emptyView_mode_desc_retry), onRetryClickListener);
            } else {
                //其他error
                emptyView.show(false, mContext.getResources().getString(R.string.emptyView_mode_desc_fail_title), null, mContext.getResources().getString(R.string.emptyView_mode_desc_retry), onRetryClickListener);
            }
            recyclerView.setVisibility(View.INVISIBLE);
            return;
        }
        if (!isSuccess) {
            emptyView.show(false, mContext.getResources().getString(R.string.emptyView_mode_desc_fail_title), null, mContext.getResources().getString(R.string.emptyView_mode_desc_retry), onRetryClickListener);
            recyclerView.setVisibility(View.INVISIBLE);
            return;
        }
        if (size == 0) {
            emptyView.show(mContext.getResources().getString(R.string.emptyView_mode_desc_double), null);
            recyclerView.setVisibility(View.INVISIBLE);
            return;
        }
        emptyView.hide();
        recyclerView.setVisibility(View.VISIBLE);
        return;
    }

    private View.OnClickListener onRetryClickListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            //重新加載
            if (onRetryListener != null) {
                onRetryListener.onRetryClick();
            }
        }
    };

    public void setOnRetryListener(OnRetryListener onRetryListener) {
        this.onRetryListener = onRetryListener;
    }

    public void setDialogAnimationListener(DialogAnimationListener dialogAnimationListener) {
        this.dialogAnimationListener = dialogAnimationListener;
    }

    public interface OnRetryListener {

        void onRetryClick();
    }
}
