package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.greendao.FoodComboDao;

import org.greenrobot.greendao.query.QueryBuilder;

import java.util.ArrayList;
import java.util.List;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */
public class FoodComboDaoUtils {

    private static final String TAG = FoodComboDaoUtils.class.getSimpleName();
    private DaoManager mManager;
    private Context mContext;

    public FoodComboDaoUtils(Context context) {
        mManager = DaoManager.getInstance();
        mManager.init(context);
        this.mContext = context;
    }

    /**
     * 清除緩存
     */
    public void detachAll(){
        FoodComboDao FoodComboDao = DaoManager.getInstance().getDaoSession().getFoodComboDao();
        FoodComboDao.detachAll();
    }


    /**
     * 完成Food记录的插入，如果表未创建，先创建Food表
     *
     * @param foodCombo
     * @return
     */
    public boolean insertCombo(FoodCombo foodCombo) {
        boolean flag = false;
        flag = mManager.getDaoSession().getFoodComboDao().insert(foodCombo) == -1 ? false : true;
        Log.i(TAG, "insert FoodCombo :" + flag + "-->" + foodCombo.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     *
     * @param foodList
     * @return
     */
    public boolean insertMultCombo(final List<FoodCombo> foodList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (FoodCombo Food : foodList) {
                        mManager.getDaoSession().insertOrReplace(Food);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     *
     * @param foodCombo
     * @return
     */
    public boolean updateCombo(FoodCombo foodCombo) {
        boolean flag = false;
        try {
            mManager.getDaoSession().update(foodCombo);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     *
     * @param food
     * @return
     */
    public boolean deleteCombo(FoodCombo food) {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(food);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     *
     * @return
     */
    public boolean deleteAll() {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(FoodCombo.class);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     *
     * @return
     */
    public List<FoodCombo> queryAllCombo() {
        return mManager.getDaoSession().loadAll(FoodCombo.class);
    }

    /**
     * 根据主键id查询记录
     *
     * @param key
     * @return
     */
    public FoodCombo queryComboById(long key) {
        return mManager.getDaoSession().load(FoodCombo.class, key);
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<FoodCombo> queryComboByNativeSql(String sql, String[] conditions) {
        return mManager.getDaoSession().queryRaw(FoodCombo.class, sql, conditions);
    }

    public List<FoodCombo> queryCombosFoodsByQueryBuilder(long fid) {
        List<FoodCombo> foodCombo = queryCombosByQueryBuilder(fid);
        List<FoodCombo> foodCombos = null;
        if (foodCombo != null && foodCombo.size() != 0) {
            foodCombos = queryCombosByComIdQueryBuilder(foodCombo.get(0).getComId());
        }
        List<FoodCombo> list = new ArrayList<>();
        FoodDaoUtils foodDao = new FoodDaoUtils(mContext);
        if (foodCombos != null) {
            for (int i = 0; i < foodCombos.size(); i++) {
                Food food = foodDao.queryFoodByFidQueryBuilder(foodCombos.get(i).getFid());
                if(food != null) {
                    list.add(foodCombos.get(i));
                }
            }
        }
        return list;
    }

    /**
     * 使用queryBuilder进行查询食品
     *
     * @return
     */
    public FoodCombo queryComboByQueryBuilder(long fid) {
        QueryBuilder<FoodCombo> queryBuilder = mManager.getDaoSession().queryBuilder(FoodCombo.class);
        return queryBuilder.where(FoodComboDao.Properties.Fid.eq(fid)).build().unique();
    }

    /**
     * 使用queryBuilder进行查询食品
     *
     * @return
     */
    public List<FoodCombo> queryCombosByQueryBuilder(long fid) {
        QueryBuilder<FoodCombo> queryBuilder = mManager.getDaoSession().queryBuilder(FoodCombo.class);
        return queryBuilder.where(FoodComboDao.Properties.Fid.eq(fid)).build().list();
    }

    /**
     * 使用queryBuilder进行查询食品
     *
     * @return
     */
    public List<FoodCombo> queryCombosByComIdQueryBuilder(int comId) {
        QueryBuilder<FoodCombo> queryBuilder = mManager.getDaoSession().queryBuilder(FoodCombo.class);
        return queryBuilder.where(FoodComboDao.Properties.ComId.eq(comId)).list();
    }
}
