package com.gingersoft.gsa.delivery_pick_mode.data

import com.gingersoft.gsa.delivery_pick_mode.data.network.CoolWeatherNetwork
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import okhttp3.FormBody

class HistoryOrderRepository private constructor(private val network: CoolWeatherNetwork) {

    suspend fun getHistoryOrderList(restaurantId: String, status: String, startDate: String, endDate: String, pageIndex: String, pageSize: String, orderType: Int, orderNo: String = "", phone: String = "") = withContext(Dispatchers.IO) {
        val builder = FormBody.Builder()
                .add("restaurantId", restaurantId)
                .add("status", status)//4為已完成 6為取消
                .add("pageIndex", pageIndex)
                .add("pageSize", pageSize)
                .add("orderNo", orderNo)
                .add("startDate", startDate)
                .add("endDate", endDate)
                .add("phone", phone)
        if (orderType == 8) {
            builder.add("orderType", orderType.toString())
        }
        val requestBody = builder.build()
        val heWeather = network.getHistoryOrderList(requestBody)
        heWeather
    }

    suspend fun getOrderInfo(orderId: String) = withContext(Dispatchers.IO) {
        val requestBody = FormBody.Builder()
                .add("orderId", orderId)
                .build()
        val data = network.getOrderInfo(requestBody)
        data
    }

    companion object {
        private lateinit var instance: HistoryOrderRepository

        fun getInstance(network: CoolWeatherNetwork): HistoryOrderRepository {
            if (!::instance.isInitialized) {
                synchronized(HistoryOrderRepository::class.java) {
                    if (!::instance.isInitialized) {
                        instance = HistoryOrderRepository(network)
                    }
                }
            }
            return instance
        }

    }
}