package com.gingersoft.gsa.delivery_pick_mode.data.network

import android.util.Log
import com.gingersoft.gsa.cloud.app.GsaCloudApplication
import com.gingersoft.gsa.cloud.base.utils.encryption.Aes
import com.gingersoft.gsa.cloud.constans.AppConstans
import com.gingersoft.gsa.cloud.constans.HttpsConstans
import com.gingersoft.gsa.cloud.constans.HttpsConstans.ROOT_SERVER
import com.gingersoft.gsa.cloud.constans.HttpsConstans.URK_RICEPON_GSA
import com.gingersoft.gsa.cloud.config.globalconfig.applyOptions.intercept.LoggingInterceptor
import com.jess.arms.utils.DeviceUtils
import okhttp3.Headers
import okhttp3.Interceptor
import okhttp3.OkHttpClient
import okhttp3.Response
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.converter.scalars.ScalarsConverterFactory
import java.util.concurrent.TimeUnit

object ServiceCreator {

    private val httpClient = OkHttpClient.Builder()
            .connectTimeout(30, TimeUnit.SECONDS)
            .callTimeout(30, TimeUnit.SECONDS)
            .readTimeout(30, TimeUnit.SECONDS)
            .writeTimeout(30, TimeUnit.SECONDS)
            .addInterceptor(LoggingInterceptor())
            .addInterceptor(UserAgentIntercepter())

    private lateinit var builder: Retrofit.Builder
    private lateinit var builder2: Retrofit.Builder
    private lateinit var builder3: Retrofit.Builder
    private lateinit var builder4: Retrofit.Builder
    private lateinit var builder5: Retrofit.Builder
    private lateinit var builderSystem: Retrofit.Builder
    private lateinit var builderActivities: Retrofit.Builder
    private lateinit var builderGSA: Retrofit.Builder
    private lateinit var builderRootGSA: Retrofit.Builder

    init {
        init()
    }

    fun init() {
        builder = Retrofit.Builder()
                .baseUrl(HttpsConstans.ricepon_wechat)
                .client(httpClient.build())

                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builder2 = Retrofit.Builder()
                .baseUrl(HttpsConstans.member_web)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builder3 = Retrofit.Builder()
                .baseUrl(HttpsConstans.member_web_ricepon_gsa)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builder4 = Retrofit.Builder()
                .baseUrl(HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builder5 = Retrofit.Builder()
                .baseUrl(HttpsConstans.ricepon_order)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builderSystem = Retrofit.Builder()
                .baseUrl(HttpsConstans.SYSTEM_URL)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builderActivities = Retrofit.Builder()
                .baseUrl(HttpsConstans.ricepon_activities)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builderGSA = Retrofit.Builder().baseUrl(ROOT_SERVER + URK_RICEPON_GSA)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
        builderRootGSA = Retrofit.Builder().baseUrl(HttpsConstans.ricepon_gsa)
                .client(httpClient.build())
                .addConverterFactory(ScalarsConverterFactory.create())
                .addConverterFactory(GsonConverterFactory.create())
    }

    fun <T> create(serviceClass: Class<T>): T = builder.build().create(serviceClass)

    fun <T> create2(serviceClass: Class<T>): T = builder2.build().create(serviceClass)

    fun <T> create3(serviceClass: Class<T>): T = builder3.build().create(serviceClass)

    fun <T> create4(serviceClass: Class<T>): T = builder4.build().create(serviceClass)

    fun <T> create5(serviceClass: Class<T>): T = builder5.build().create(serviceClass)

    fun <T> createSystem(serviceClass: Class<T>): T = builderSystem.build().create(serviceClass)

    fun <T> createActivities(service: Class<T>): T = builderActivities.build().create(service)

    fun <T> createGSA(service: Class<T>): T = builderGSA.build().create(service)

    fun <T> createRootGSA(service: Class<T>): T = builderRootGSA.build().create(service)

    /**
     * 添加请求头
     */
    class UserAgentIntercepter : Interceptor {
        override fun intercept(chain: Interceptor.Chain): Response {
            val request = chain.request()
            val headers = request.headers()

            val builder = Headers.Builder()
            for (i in 0 until headers.size()) {
                builder.set(headers.name(i), headers.value(i))
            }

            builder.set("mobileVersion", android.os.Build.VERSION.RELEASE)//set表示name1是唯一的，会覆盖掉已经存在的，add不会覆盖已经存在的头，可以存在多个
            builder.set("mobielModel", android.os.Build.MODEL)
            builder.set("apptype", AppConstans.APP_TYPE)
            builder.set("appinfo", DeviceUtils.getVersionName(GsaCloudApplication.getAppContext()))
            builder.set("mobileId", "1")

            if (GsaCloudApplication.isLogin) {
                var token: String
                val memberId = GsaCloudApplication.getMemberId()
                val loginToken = GsaCloudApplication.getLoginToken()
                token = Aes.aesEncrypt("9_" + memberId + "_" + System.currentTimeMillis() + "_" + loginToken)
                token = token.replace("\r|\n".toRegex(), "")
                builder.set("token", token)
            }
            val request1 = chain.request().newBuilder().headers(builder.build()).build()
            return chain.proceed(request1)
        }
    }
}