package com.gingersoft.gsa.delivery_pick_mode.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.delivery_pick_mode.mvp.bean.PrjQueryBean;
import com.gingersoft.gsa.delivery_pick_mode.mvp.contract.PrjQueryContract;
import com.gingersoft.gsa.delivery_pick_mode.mvp.server.PrjQueryServer;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 10/20/2020 09:34
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class PrjQueryModel extends BaseModel implements PrjQueryContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public PrjQueryModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<PrjQueryBean> getKitchenPrint(String orderId) {
        return mRepositoryManager.obtainRetrofitService(PrjQueryServer.class).
                getKitchenPrint(orderId, GsaCloudApplication.getRestaurantId() + "");
    }

    @Override
    public Observable<BaseResult> updatePrjState(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(PrjQueryServer.class).
                updatePrjState(requestBody);
    }
}