package com.gingersoft.gsa.cloud.main.mvp.model.bean;

import java.util.List;

import lombok.Data;
import me.yokeyword.fragmentation.ISupportFragment;

@Data
public class FoodMenuEditBean {
    /**
     * 線條
     */
    public final static int EDIT_FOOD_ITEM_THICK_LINE = 0;
    /**
     * 輸入框類型
     */
    public final static int EDIT_FOOD_ITEM_INPUT = 1;

    /**
     * 進入下一頁面的選擇類型
     */
    public final static int EDIT_FOOD_ITEM_SELECT = 2;
    /**
     * 選擇時間的類型
     */
    public final static int EDIT_FOOD_ITEM_SELECT_TIME = 3;

    /**
     * boolean類型
     */
    public final static int EDIT_FOOD_ITEM_BOOLEAN = 4;
    /**
     * 上傳圖片
     */
    public final static int EDIT_FOOD_ITEM_UPLOAD_PIC = 5;
    /**
     * 多選
     */
    public final static int EDIT_FOOD_ITEM_CHECKBOX = 6;
    /**
     * 單選
     */
    public final static int EDIT_FOOD_ITEM_RADIO = 7;

    public int itemType;

    /**
     * 用於顯示的標題
     */
    private String showTitle;
    /**
     * 是否必填
     */
    private boolean isRequired;

    /**
     * 提示文字
     */
    private String hintText;

    /**
     * 多選數據
     */
    private List<ShowClient> checkBoxList;

    private String foodName1;
    private String foodName2;
    private String foodName3;
    /**
     * 時段
     */
    private String timePeriod;
    /**
     * 餐種
     */
    private String foodType;
    /**
     * 顯示狀態，多個端顯示
     */
    private boolean showState;

    private String foodGroup;
    /**
     * 食品金額
     */
    private double foodAmount;
    /**
     * 食品原價
     */
    private double foodOriginalPrice;

    private String printLocation;

    private String foodDesc;
    /**
     * 用於顯示的值
     */
    private String showValue;

    private Class<? extends ISupportFragment> toFragment;
    /**
     * {@link com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.FoodMenuFragment.FRAGMENT_TYPE}
     */
    private int fragmentType;

    /**
     * 是否控制客戶端顯示
     */
    private boolean isShowClient = false;
    /**
     * 是否可編輯
     */
    private boolean isEdit = true;
    /**
     * 選擇類型，當item類型為EDIT_FOOD_ITEM_SELECT時，有選擇時間，日期，
     */
    private int selectType;

    public final static int SELECT_DATE = 1;
    public final static int SELECT_TIME = 2;

    /**
     * 顯示端
     */
    @Data
    public static class ShowClient {
        private String clientName;
        private boolean isChecked;

        public ShowClient(String clientName, boolean isChecked) {
            this.clientName = clientName;
            this.isChecked = isChecked;
        }
    }

    public FoodMenuEditBean() {
    }

    public FoodMenuEditBean(int itemType) {
        this.itemType = itemType;
    }

    public FoodMenuEditBean(int itemType, String showTitle, boolean isRequired) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
    }

    public FoodMenuEditBean(int itemType, String showTitle, boolean isRequired, String hintText, boolean isEdit) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.hintText = hintText;
        this.isEdit = isEdit;
    }

    public FoodMenuEditBean(int itemType, String showTitle, boolean isRequired, String hintText) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.hintText = hintText;
    }

    public FoodMenuEditBean(int itemType, String showTitle, boolean isRequired, String hintText, String showValue) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.hintText = hintText;
        this.showValue = showValue;
    }

    public FoodMenuEditBean(int itemType, String showTitle, boolean isRequired, String hintText, String showValue, int selectType) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.hintText = hintText;
        this.showValue = showValue;
        this.selectType = selectType;
    }

    public FoodMenuEditBean(int itemType, String showTitle, boolean isRequired, String hintText, int fragmentType) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.hintText = hintText;
        this.fragmentType = fragmentType;
    }

    public FoodMenuEditBean(int itemType, String showTitle, boolean isRequired, boolean showState) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.showState = showState;
    }

    public FoodMenuEditBean(int itemType, String showTitle, boolean isRequired, boolean showState, boolean isShowClient) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.showState = showState;
        this.isShowClient = isShowClient;
    }

    public FoodMenuEditBean(int itemType, String showTitle, boolean isRequired, boolean showState, List<ShowClient> checkBoxList) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.showState = showState;
        this.checkBoxList = checkBoxList;
    }

    public FoodMenuEditBean(int itemType, String showTitle, boolean isRequired, List<ShowClient> checkBoxList) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.checkBoxList = checkBoxList;
    }
}
