package com.joe.print.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.PrinterManger.PrinterManager;
import com.gingersoft.gsa.cloud.base.utils.JsonUtils;
import com.gingersoft.gsa.cloud.database.bean.PrintModelBean;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.database.bean.PrinterListBean;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;
import com.joe.print.mvp.contract.IpPrintListActivityContract;

import java.util.List;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.RequestBody;


@FragmentScope
public class IpPrintListActivityPresenter extends BasePresenter<IpPrintListActivityContract.Model, IpPrintListActivityContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public IpPrintListActivityPresenter(IpPrintListActivityContract.Model model, IpPrintListActivityContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }


    /**
     * 獲取打印機列表
     *
     * @param restaurantId 餐廳id
     */
    public void getPrinterList(int restaurantId) {
        mModel.getPrinterList(restaurantId)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult.isSuccess()) {
                            PrinterListBean printerListBean = JsonUtils.parseObject(baseResult.getData(), PrinterListBean.class);
                            if(printerListBean != null) {
                                List<PrinterDeviceBean> deviceBeans = printerListBean.getList();
                                if (deviceBeans != null && deviceBeans.size() > 0) {
                                    mRootView.loadPrinterList(deviceBeans);
                                    PrinterManager.getPrinterManager().setDeviceBeans(deviceBeans);
                                } else {
                                    mRootView.loadFile();
                                }
                            } else {
                                mRootView.loadFile();
                            }
                        } else {
                            mRootView.loadFile();
                        }
                    }
                });
    }

    /**
     * 刪除打印機
     *
     * @param ids 打印機id，可以傳多個 例如：1,2,3
     */
    public void deletePrinter(String ids) {
        RequestBody requestBody = new FormBody.Builder()
                .add("id", ids)
                .build();
        mModel.deletePrinter(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {

                    }
                });
    }

    private List<PrintModelBean> printModelBeans;
    public List<PrintModelBean> getPrintModelBeans() {
        return printModelBeans;
    }

    /**
     * 獲取打印機機型列表
     */
    public void getModelList(int restaurantId) {
        mModel.getPrintModel(restaurantId)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult.isSuccess()) {
                            printModelBeans = JsonUtils.parseArray(baseResult.getData(), PrintModelBean.class);
                        }
                    }
                });
    }

}
