package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.order.TakeawayOrder;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.PrintBillBean;
import com.joe.print.mvp.ui.adapter.BillItemAdapter;
import com.joe.print.mvp.ui.adapter.OtherOrderAdapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 打印外賣接單   結賬單
 */
public class PrintOtherOrderClosing extends PrinterRoot {

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        OrderDetails.DataBean dataBean = TakeawayOrder.getInstance().getShoppingCart().getDataBean();
        if (dataBean != null) {
            Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
            List<Bitmap> bitmaps = new ArrayList<>();
            bitmaps.add(getBitmap(mContext, dataBean, deviceBean));
            bitmapMaps.put("", bitmaps);
            return bitmapMaps;
        }
        return null;
    }

    @Override
    public String getPrintData(Context mContext, PrinterDeviceBean deviceBean) {
        return null;
    }

    @Override
    public int getPrintCount(Context context) {
        return RestaurantExpandInfoUtils.getValue(ExpandConstant.DeliveryClosingPC,1);
    }

    private Bitmap initPrintView(Context context, OrderDetails.DataBean data, PrinterDeviceBean deviceBean) {
        View view = LayoutInflater.from(context).inflate(R.layout.print_confirm_order_view, null, false);
        TextView tvMemberNum = view.findViewById(R.id.tv_member_number);//會員號碼
        TextView tvMemberName = view.findViewById(R.id.tv_member_name);//會員名稱
        TextView tvMemberPhone = view.findViewById(R.id.tv_member_phone);//會員電話
        TextView tvNowPoint = view.findViewById(R.id.tv_nowPoints);//現在的積分
        TextView tvAddPoints = view.findViewById(R.id.tv_addPoints);//本次添加積分
        TextView tvOldPoints = view.findViewById(R.id.tv_oldPoints);//之前的積分
        TextView lineMember = view.findViewById(R.id.line_member_info);
        TextView tvOrderClosing = view.findViewById(R.id.tv_order_closing);
        TextView tvBillNumber = view.findViewById(R.id.tv_bill_number);
        TextView tvPayMethodTwo = view.findViewById(R.id.tv_pay_amount_text_two);
        //品牌名
        setText(view, R.id.tv_brand_name, GsaCloudApplication.getBrandName());
        //餐廳名
        setText(view, R.id.tv_restaurant_name, GsaCloudApplication.getRestaurantName());

        // 訂單號
        setText(view, R.id.tv_order_number, "單號：" + data.getORDER_NO());
        tvBillNumber.setVisibility(View.GONE);
        if (data.getOrder_type() == 2) {
            //外送
            // 訂單類型
            setText(view, R.id.tv_order_type, "外送");
            if (data.getTakeFoodCode() != null && !data.getTakeFoodCode().equals("0")) {
                setText(view, R.id.tv_order_take_food_code, "訂單碼：" + data.getTakeFoodCode());
            } else if (data.getBillNo() != null && data.getBillNo().length() > 0) {
                setText(view, R.id.tv_order_take_food_code, "訂單碼：" + data.getTakeFoodCode());
            }
        } else {
            setText(view, R.id.tv_order_type, "自取");
            if (data.getBillNo() != null && data.getBillNo().length() > 0) {
                setText(view, R.id.tv_order_take_food_code, "訂單碼：" + data.getBillNo());
            } else if (data.getTakeFoodCode() != null && !data.getTakeFoodCode().equals("0")) {
                setText(view, R.id.tv_order_take_food_code, "訂單碼：" + data.getTakeFoodCode());
            }
        }
        //訂單創建時間
        setText(view, R.id.tv_order_create, context.getString(R.string.create_order_time) + TimeUtils.parseTimeRepeat(data.getCREATE_TIME(), TimeUtils.DEFAULT_DATE_FORMAT));
        String amountUnit = context.getString(R.string.amount_unit);

        RecyclerView rvBill = view.findViewById(R.id.rv_bill);
        List<PrintBillBean> billData = new ArrayList<>();
        billData.add(getBillBean("合計：", amountUnit + MoneyUtil.sub(MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getLunchbox()), data.getDELIVERY_CHARGE())));
        if (data.getLunchbox() != 0) {
            billData.add(getBillBean("餐盒費：", amountUnit + data.getLunchbox()));
        }
        if (data.getDELIVERY_CHARGE() != 0) {
            billData.add(getBillBean("送貨費：", amountUnit + data.getDELIVERY_CHARGE()));
        }
        if (data.getCouponList() != null && data.getCouponList().size() > 0) {
            for (OrderDetails.DataBean.CouponBean coupon : data.getCouponList()) {
                billData.add(getBillBean(coupon.getCouponName() + "：", "-$" + coupon.getDiscount_amount()));
            }
        }
        BillItemAdapter adapter = new BillItemAdapter(billData);
        rvBill.setLayoutManager(new LinearLayoutManager(context));
        rvBill.setAdapter(adapter);
        //總金額
        setText(view, R.id.tv_total, amountUnit + data.getTOTAL_AMOUNT());
        if (data.getOrderPayType() == 1) {
            //貨到付款
            setText(view, R.id.tv_pay_type, "貨到付款");
//            if (data.getPayName() != null) {
//                //支付金額
//                setText(view, R.id.tv_pay_amount_text, data.getPayName() + "：" + amountUnit + MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getDiscount_amount()));
//            } else {
            setIsShow(view, R.id.tv_pay_amount_text, false);
            setIsShow(view, R.id.tv_pay_amount_line, false);
//            }
        } else if (data.getOrderPayType() == 0) {
            setText(view, R.id.tv_pay_type, "店內支付");
        } else if (data.getOrderPayType() == 2) {
            setText(view, R.id.tv_pay_type, "在線支付");
//            setText(view, R.id.tv_pay_amount_text, data.getPayName() + "：" + amountUnit + MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getDiscount_amount()));
//            setText(view, R.id.tv_pay_amount_text, data.getPayName() + "：" + amountUnit + data.getPayAmount());
        }
        if (data.getPayTime() != null) {
            tvOrderClosing.setText("結賬時間：" + data.getPayTime());
            tvOrderClosing.setVisibility(View.VISIBLE);
        }
        //收貨時間
        setText(view, R.id.tv_delivery_time, data.getOrder_type() == 2 ? data.getSEND_TIME() : data.getTakeTime());
        if (data.getOrder_type() != 2) {
            //自取，隱藏地址和收貨人
            view.findViewById(R.id.tv_address).setVisibility(View.GONE);
            view.findViewById(R.id.tv_receiver).setVisibility(View.GONE);
        } else {
            //收貨地址
            setText(view, R.id.tv_address, context.getString(R.string.address) + data.getAddressDetail());
            //收貨人
            setText(view, R.id.tv_receiver, "收貨人：" + data.getRECEIVER());
        }
        //手機號
        setText(view, R.id.tv_phone, "手機號：" + data.getPHONE());
        //備註
        if (data.getRemark() != null && !data.getRemark().isEmpty()) {
            setText(view, R.id.tv_remark, "備註：" + data.getRemark());
            view.findViewById(R.id.tv_remark).setVisibility(View.VISIBLE);
        } else {
            view.findViewById(R.id.tv_remark).setVisibility(View.GONE);
        }
        if (data.getPRODUCT_NAME() != null) {
            RecyclerView rvFoodList = view.findViewById(R.id.rv_order_print_food);
            rvFoodList.setLayoutManager(new LinearLayoutManager(context));
            rvFoodList.setAdapter(new OtherOrderAdapter(context, data.getPRODUCT_NAME(), true));
        }
        if (data.getAddPoints() != 0 || data.getOldPoints() != 0 || data.getAddPoints() != 0) {
            tvAddPoints.setText("本次積分：" + data.getAddPoints());
            tvNowPoint.setText("結餘積分：" + data.getNowPoints());
            tvOldPoints.setText("上次積分：" + data.getOldPoints());
            //名稱中間替換為*號
            if (data.getMEMBER_NAME() != null && data.getMEMBER_NAME().length() > 0) {
                tvMemberName.setText("會員名稱：" + getReplaceAfter(data.getMEMBER_NAME()));
                tvMemberName.setVisibility(View.VISIBLE);
            }
            if (data.getPHONE() != null && data.getPHONE().length() > 0) {
                tvMemberPhone.setText("會員電話：" + getReplaceAfter(data.getPHONE()));
                tvMemberPhone.setVisibility(View.VISIBLE);
            }
            tvMemberName.setVisibility(View.VISIBLE);
            tvAddPoints.setVisibility(View.VISIBLE);
            tvNowPoint.setVisibility(View.VISIBLE);
            tvOldPoints.setVisibility(View.VISIBLE);
            lineMember.setVisibility(View.VISIBLE);
        }
        return viewToZoomBitmap(context, view, deviceBean);
    }

    private Bitmap getBitmap(Context mContext, OrderDetails.DataBean data, PrinterDeviceBean deviceBean) {
        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);
        //頭部
        layout.addView(getHeader(mContext));
        //訂單信息
        layout.addView(getTakeawayOrderInfo(mContext, data));
        //食品
        layout.addView(getTextLine(mContext, "項目"));
        layout.addView(getDiningFoodList(mContext, OrderDetail.productMameBeanToOrderDetail(1, data.getPRODUCT_NAME()), deviceBean, 1, true));
        layout.addView(getLine(mContext));
        //訂單金額信息
        List<PrintBillBean> billData = new ArrayList<>();
        billData.add(getBillBean("合計：", MONETARY_UNIT + MoneyUtil.sub(MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getLunchbox()), data.getDELIVERY_CHARGE())));
        if (data.getLunchbox() != 0) {
            billData.add(getBillBean("餐盒費：", MONETARY_UNIT + data.getLunchbox()));
        }
        if (data.getDELIVERY_CHARGE() != 0) {
            billData.add(getBillBean("送貨費：", MONETARY_UNIT + data.getDELIVERY_CHARGE()));
        }
        if (data.getCouponList() != null && data.getCouponList().size() > 0) {
            for (OrderDetails.DataBean.CouponBean coupon : data.getCouponList()) {
                billData.add(getBillBean(coupon.getCouponName() + "：", "-" + MONETARY_UNIT + coupon.getDiscount_amount()));
            }
        }
        layout.addView(getTakeawayBillInfoView(mContext, billData));
        layout.addView(getLine(mContext));
        //總金額34sp
        layout.addView(getTakeawayLargeAmount(mContext, "總金額：", MONETARY_UNIT + data.getTOTAL_AMOUNT()));
        layout.addView(getLine(mContext));
//        if (data.getPayMultiple() != null && data.getPayMultiple().size() > 0) {
//            for (OrderDetails.DataBean.PayMultiple payMultiple : data.getPayMultiple()) {
//                if (!TextUtil.isEmptyOrNullOrUndefined(payMultiple.getPayName())) {
//                    layout.addView(getTakeawayLargeAmount(mContext, payMultiple.getPayName(), MONETARY_UNIT + payMultiple.getAmount()));
//                }
//            }
//            layout.addView(getLine(mContext));
//        } else {
//            layout.addView(getTakeawayLargeAmount(mContext, "支付金額：", MONETARY_UNIT + MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getDiscount_amount()) + ""));
//        }
        addTakeawayPayViews(mContext, layout, data.getPayMultiple(), MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getDiscount_amount()));

        //會員信息
        layout.addView(getTakeawayMemberIntegerView(mContext, data));
        layout.addView(getLine(mContext));

        getTakeawayReceiver(mContext, data, layout);

        return viewToZoomBitmap(mContext, layout, deviceBean);
    }

    private PrintBillBean getBillBean(String title, String value) {
        return new PrintBillBean(title, value);
    }

}