package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.Gravity;
import android.widget.LinearLayout;

import com.gingersoft.gsa.cloud.base.common.bean.BillingBean;
import com.gingersoft.gsa.cloud.base.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.base.order.billItem.BillOrderMoney;
import com.gingersoft.gsa.cloud.base.order.cart.ShoppingCart;
import com.gingersoft.gsa.cloud.base.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.base.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.base.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 印單打印  已改新版
 */
public class PrintSlip extends PrinterRoot {

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, deviceBean));
        bitmapMaps.put("", bitmaps);
        //這裡可能還需要加上廚房單的內容，有未送單的食品時。
//        PrintKitchen kitchen = new PrintKitchen();
//        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>(kitchen.getPrintBitmap(mContext, deviceBean));
//        if (bitmapMaps.size() == 0) {
//            bitmapMaps.put("", bitmaps);
//        } else {
//            merge2ResultMap(bitmapMaps, "", bitmaps);
//        }
        return bitmapMaps;
    }

    @Override
    public String getPrintData(Context mContext, PrinterDeviceBean deviceBean) {
        List<OrderDetail> foodList = DoshokuOrder.getInstance().getShoppingCart().getOrderCommodityList();
        TableBean.DataBean tableBean = DoshokuOrder.getInstance().getOpenTableInfo();

        String stringBuilder = "<html><body>" +
                getHtmlPrintHeadInfo() +
                getHtmlPrintHeadOrderInfo(tableBean) +
                generateFoodInfo(foodList) +
                getHtmlBillInfo() +
                getWholeLine() +
                getHtmlFooter() + "</body></html>";
        return stringBuilder;
    }

    private String getPLable(String content) {
        return "<p>" + content + "</p>";
    }

    @Override
    public int getPrintCount(Context context) {
        return RestaurantExpandInfoUtils.getValue(ExpandConstant.TableModePrintCount, 1);
    }

    private Bitmap getBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {

        DoshokuOrder doshokuOrder = DoshokuOrder.getInstance();
        ShoppingCart shoppingCart = doshokuOrder.getShoppingCart();


        List<OrderDetail> foodList = shoppingCart.getOrderCommodityList();
        if (foodList == null || foodList.size() <= 0) {
            return null;
        }
        TableBean.DataBean tableBean = doshokuOrder.getOpenTableInfo();

        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);

        //訂單頭
        layout.addView(getHeader(mContext));
        layout.addView(getLine(mContext));

        //訂單信息
        layout.addView(getDiningTableOrderInfo(mContext, "餐檯：" + tableBean.getTableName(), "人數：" + doshokuOrder.getOpenTableInfo().getPerson(), "單號：" +doshokuOrder.getOrderNo(), "日期：" + TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT)));
        layout.addView(getLine(mContext));

        layout.addView(getDiningFoodList(mContext, foodList, printerDeviceBean, 0, true));
        layout.addView(getHalfLine(mContext));
        List<BillingBean> billingBeans = new ArrayList<>();
        //添加合計項
        billingBeans.add(new BillingBean("合計", shoppingCart.getWholeAmount()));
        //添加其他金額項
        if (shoppingCart.getBillItemList().size() > 0) {
            for (BillItem item : shoppingCart.getBillItemList()) {
                billingBeans.add(new BillingBean(item.getName(), item.getMoney()));
            }
        }
        layout.addView(getDiningBillInfo(mContext, billingBeans));
        layout.addView(getHalfLine(mContext));
        layout.addView(getAmountText(mContext, "總金額：" + shoppingCart.getTotalAmount()));
        layout.addView(getLine(mContext));
        layout.addView(getTextView(mContext, "Thank you!", Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        layout.addView(getTextView(mContext, TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT), Gravity.CENTER_HORIZONTAL, getDimensionPixelSize(mContext, R.dimen.dp_8)));
        return viewToZoomBitmap(mContext, layout, printerDeviceBean);
    }


}
