package com.joe.print.mvp.ui.adapter;

import android.content.Context;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;
import com.joe.print.mvp.ui.activity.PrinterAddActivity;

import java.util.List;

/**
 * Created by Wyh on 2020/1/16.
 */
public class DialogPrinterListAdapter extends BaseQuickAdapter<PrinterDeviceBean, BaseViewHolder> {
    private Context mContext;

    public DialogPrinterListAdapter(@Nullable List<PrinterDeviceBean> data, Context mContext) {
        super(R.layout.printer_dialog_item, data);
        this.mContext = mContext;
    }

    @Override
    protected void convert(BaseViewHolder helper, PrinterDeviceBean item) {
        helper.setText(R.id.tv_printer_name, item.getName() + "");
        if (item.getPrinterDeviceType() == 1) {
            helper.setText(R.id.tv_printer_ip, String.format(mContext.getString(R.string.print_ip), item.getIp()));
        } else {
            helper.setText(R.id.tv_printer_ip, PrinterAddActivity.printTypes.get(item.getPrinterDeviceType() - 1));
        }

//        helper.setText(R.id.tv_printer_port, String.format(mContext.getString(R.string.print_port), item.getPort() + ""));
    }
}
