package com.gingersoft.supply_chain.mvp.bean;

import com.gingersoft.supply_chain.R;

import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/23
 * Time: 18:00
 * Use:
 */
@Data
public class PurchaseOrderDetailsBean {

    /**
     * id : 92
     * orderNo : JK1630553667
     * createTime : 1608365460896
     * initialShippingTime : 1608451855391
     * totalAmount : 100.1
     * shipping : 0
     * actualPayment : 100.1
     * status : 1
     * <p>
     * purchaseOrderDetailsInfoVOS : [{"id":65,"foodQuantity":1,"foodPrice":100,"status":1,"purchaseFoodId":3,"images":"https://baike.baidu.com/pic/%E9%A6%99%E8%95%89/150475/1/5d6034a85edf8db12c69     f8ef0f23dd54574e74f2?fr=lemma&amp;ct=single#aid=1&amp;pic=5d6034a85edf8db12c69f8ef0f23dd54574e74f2","foodNo":"1606560266815","quantityStarts":4,"quantityEnd":9,"type":1,"unit_content":"ML"}]
     */
    private int id;
    private String orderNo;
    private long createTime;
    private String initialShippingTime;
    private double totalAmount;
    private int shipping;
    private double actualPayment;
    /**
     * 入库单号
     */
    private String warehousingOrderNo;
    /**
     * 入庫備註
     */
    private String warehousingRemarks;
    /**
     * 下採購單時的備註
     */
    private String remarks;
    /**
     * 收貨時上傳的圖片，可以多張，用逗號隔開
     */
    private String files;

    /**
     * 狀態：0全部 1待收貨 2部分收貨 3已完成 4拒收
     */
    private int status;
    public static final int ALL = 0;

    private static String[] states = new String[]{"", "待收貨", "部分收貨", "已完成", "拒收"};
    private static int[] colors = new int[]{R.color.color_3c, R.color.order_state0_color, R.color.order_state5_color, R.color.brick_red, R.color.red};

    public static String getStringByOrderState(int state) {
        if (state < 0 || state > states.length) {
            return "";
        }
        return states[state];
    }

    public static int getColorByOrderState(int state) {
        if (state < 0 || state > colors.length) {
            return colors[0];
        }
        return colors[state];
    }

    /**
     * 待收貨
     */
    public static final int WAIT_RECEIVED = 1;
    /**
     * 部分收貨
     */
    public static final int PART_RECEIVED = 2;
    /**
     * 全部收貨
     */
    public static final int COMPLETE_RECEIVED = 3;
    /**
     * 拒收
     */
    public static final int REFUSE_RECEIVED = 4;

    private String supplierName;
    private List<PurchaseOrderDetailsInfoVosBean> purchaseOrderDetailsInfoVOS;

    @Data
    public static class PurchaseOrderDetailsInfoVosBean {
        /**
         * id : 65
         * foodQuantity : 1
         * foodPrice : 100
         * status : 1
         * purchaseFoodId : 3
         * images : https://baike.baidu.com/pic/%E9%A6%99%E8%95%89/150475/1/5d6034a85edf8db12c69     f8ef0f23dd54574e74f2?fr=lemma&amp;ct=single#aid=1&amp;pic=5d6034a85edf8db12c69f8ef0f23dd54574e74f2
         * foodNo : 1606560266815
         * quantityStarts : 4
         * quantityEnd : 9
         * type : 1
         * unit_content : ML
         */
        private int id;
        /**
         * 食品數量
         */
        private int foodQuantity;
        private double foodPrice;
        /**
         * 看上面{@link WAIT_RECEIVED}
         */
        private int status;
        private int purchaseFoodId;
        private String images;
        private String foodNo;
        /**
         * 基本單位
         */
        private String basicUnitName;
        /**
         * 包裝描述
         */
        private String packingDescription;
        private int quantityStarts;
        private int quantityEnd;
        private int type;
        private String unit_content;
        private String name;
        //自定義字段，總價
        private double totalAmount;
        //入庫總價
        private double warehousingAmount;
        //是否被選中
        private boolean isChecked = false;
        /**
         * 未入庫時，後台傳來的副單位集合
         */
        private List<DeputyUnitBean> foodUnits;
        /**
         * 入庫後，後台傳來的副單位數據
         */
        WareHousingUnitBean purchaseWarehousingUnit;
        /**
         * 已入庫數量
         */
        private double warehousingQuantity;
//        List<DeputyUnitBean> deputyUnitBeans;
        /**
         * 沒有入庫單號，暫時用訂單編號
         */
        private String orderNo;

        private DeputyUnitBean showUnit;
        /**
         * {@link PurchaseFoodBean.NOT_HAS_SN}
         * {@link  PurchaseFoodBean.HAS_SN}
         */
        private int foodMarkSn;
        /**
         * sn集合，掃描了sn之後，裝在這裡面
         */
        private List<PurchaseFoodEncodeSn> purchaseFoodEncodeSns;
    }
}
