package com.gingersoft.gsa.delivery_pick_mode.ui.adapter

import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.gingersoft.gsa.cloud.common.ui.utils.BtnBuilder
import com.gingersoft.gsa.delivery_pick_mode.R

class OrderBtnAdapter(var list: MutableList<BtnBuilder.BtnBean>) : RecyclerView.Adapter<OrderBtnAdapter.ViewHolder>() {

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val btnBuilder = list[position]
        holder.btn.text = btnBuilder.btnContent
        holder.btnImg.setBackgroundColor(btnBuilder.btnColor)
        holder.btnImg.setImageResource(btnBuilder.btnImg)
    }

    override fun getItemCount() = list.size

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int) = ViewHolder(View.inflate(parent.context, R.layout.item_btn, null))

    class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        var layout: LinearLayout = view.findViewById(R.id.layout_btn_item)
        var btnImg: ImageView = view.findViewById(R.id.iv_btn_mark)
        var btn: TextView = view.findViewById(R.id.tv_btn_content)
    }
}